% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmuOldPlotIP.r
\name{xmuOldPlotIP}
\alias{xmuOldPlotIP}
\title{Draw a graphical figure for a Independent Pathway model}
\usage{
xmuOldPlotIP(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  format = c("current", "graphviz", "DiagrammeR"),
  SEstyle = FALSE,
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{The \code{\link[=umxIP]{umxIP()}} model to plot}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{SEstyle}{Report "b (se)" instead of "b [lower, upper]" (Default)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item optionally return the dot code
}
}
\description{
Options include digits (rounding), showing means or not, standardization, and which output format is desired.
}
\examples{
\dontrun{
require(umx)
data(GFF)
mzData = subset(GFF, zyg_2grp == "MZ")
dzData = subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff","fc","qol","hap","sat","AD") # These will be expanded into "gff_T1" "gff_T2" etc.
m1 = umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
xmuOldPlotIP(model, file = NA)
}
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxIP]{umxIP()}}
}

Other umx deprecated: 
\code{\link{umx-deprecated}}
}
\concept{umx deprecated}
