% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_read_prolific_demog}
\alias{umx_read_prolific_demog}
\title{Read and optionally merge demographics file from prolific academic}
\usage{
umx_read_prolific_demog(
  file,
  base = "",
  df = NULL,
  by.df = "PROLIFIC_PID",
  by.demog = by.df,
  age = "age",
  sex = "Sex",
  vars = NULL,
  all.df = TRUE,
  all.demog = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{Path to a file to read.}

\item{base}{Optional path to folder, in which case 'file' is just filename.}

\item{df}{Existing datafile to merge demographics into (optional)}

\item{by.df}{The ID name in your datafile (default = "PROLIFIC_PID" (WAS "PID")}

\item{by.demog}{The ID name in the prolific demographics file (default = by.demog (WAS "participant_id")}

\item{age}{Name of sex var in demographics file ("age")}

\item{sex}{Name of sex var in demographics file ("Sex")}

\item{vars}{Additional vars to keep from demographics file (WAS age & Sex)}

\item{all.df}{Whether to keep all lines of df (default = TRUE)}

\item{all.demog}{Whether to keep all lines (people) in the demographics file (default = FALSE)}

\item{verbose}{Print variable names found in the file.}
}
\value{
\itemize{
\item [\link{data.frame}]
}
}
\description{
prolific academic provides a demographics file. This reads it and merges with your data
using PID and participant_id
}
\examples{
\dontrun{
fp = "~/Desktop/prolific_export_5f20c3e662e3b6407dcd37a5.csv"
df = umx_read_prolific_demog(fp, sex = "gender", df = df)
tmp = umx_read_prolific_demog(fp, by.df = "PROLIFIC_PID", vars=c("EthnicitySimplified"))
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_check_ID}()},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_merge_randomized_columns}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
