% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_checkpoint}
\alias{umx_set_checkpoint}
\alias{umx_checkpoint}
\title{umx_set_checkpoint}
\usage{
umx_set_checkpoint(
  interval = 1,
  units = c("evaluations", "iterations", "minutes"),
  prefix = "",
  directory = getwd(),
  model = NULL
)
}
\arguments{
\item{interval}{How many units between checkpoints: Default =  1.
A value of zero sets always to 'No' (i.e., do not checkpoint all models during optimization)}

\item{units}{units to count in: Default unit is 'evaluations' ('minutes' is also legal)}

\item{prefix}{string prefix to add to all checkpoint filenames (default = "")}

\item{directory}{a directory, i.e "~/Desktop" (defaults to getwd())}

\item{model}{(optional) model to set options in (default = NULL)}
}
\value{
\itemize{
\item mxModel if provided
}
}
\description{
Set the checkpoint status for a model or global options
}
\examples{

\dontrun{
umx_set_checkpoint(interval = 1, "evaluations", dir = "~/Desktop/")
# Turn off checkpointing with interval = 0
umx_set_checkpoint(interval = 0)
umx_set_checkpoint(2, "evaluations", prefix="SNP_1")
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
m1 = umx_set_checkpoint(model = m1)
m1 = mxRun(m1)
umx_checkpoint(0)
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_plot_use_hrbrthemes}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
