% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_interest}
\alias{fin_interest}
\title{Compute the value of a principal & annual deposits at a compound interest over a number of years}
\usage{
fin_interest(
  principal = 0,
  deposits = 0,
  dinflate = 0,
  interest = 0.05,
  yrs = 10,
  n = 12,
  when = "beginning",
  symbol = "$",
  largest_with_cents = 0,
  baseYear = as.numeric(format(Sys.time(), "\%Y")),
  table = TRUE,
  report = c("markdown", "html")
)
}
\arguments{
\item{principal}{The initial investment at time 0.}

\item{deposits}{Optional periodic additional investment each \emph{year}.}

\item{dinflate}{How much to inflate deposits over time (default = 0)}

\item{interest}{Annual interest rate (default = .05)}

\item{yrs}{Duration of the investment (default = 10).}

\item{n}{Compounding intervals per year (default = 12 (monthly), 365 for daily)}

\item{when}{Deposits made at the "beginning" (of each year) or "end"}

\item{symbol}{Currency symbol to embed in the result.}

\item{largest_with_cents}{Default = 0}

\item{baseYear}{Default = 0, can set, e.g. to 2020 for printing}

\item{table}{Whether to print a table of annual returns (default TRUE)}

\item{report}{"markdown" or "html",}
}
\value{
\itemize{
\item Value of balance after yrs of investment.
}
}
\description{
Allows you to determine the final value of an initial \code{principal} (with optional
periodic \code{deposits}), over a number of years (\code{yrs}) at a given rate of \code{interest}.
Principal and deposits are optional. You control compounding periods each year (n) and whether deposits occur at the beginning or end of the year.
The function outputs a nice table of annual returns, formats the total using a user-settable currency \code{symbol}. Can also \code{report} using a web table.
}
\examples{
# Value of a principal after yrs years at 5\% return, compounding monthly.
# Report as a nice table of annual returns and a formatted total:
fin_interest(principal = 5000, interest = 0.05, yrs = 10)

\dontrun{
# Make a nice table and open in web browser...
fin_interest(principal = 5000, interest = 0.05, rep= "html")
}

# Value of periodic deposit of $100/yr after 10 years at rate 7\% return.
fin_interest(deposits = 100, interest = 0.07, yrs = 10, n = 12)

# Annual rather than monthly compounding (n=1)
fin_interest(deposits = 100, interest = 0.07, yrs = 10, n=1)

# Value of principal + deposits of $100/yr over 10 years at 7\% return.
fin_interest(principal = 20000, deposits = 100, interest = 0.07, yrs = 10)

# £20k at 7\% once a year for 10 years
fin_interest(deposits=20e3, interest = 0.07, yrs = 10, n=1)
# $295,672

# manual sum
sum(20e3*(1.07^(10:1))) # 295672

# $10,000 invested at the end of each year for 5 years at 6\%
fin_interest(deposits = 10e3, interest = 0.06, yrs = 5, n=1, when= "end")

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}, \href{https://github.com/tbates/umx}{github}
}
}
\seealso{
\itemize{
\item \code{\link[=fin_percent]{fin_percent()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_percent}()},
\code{\link{fin_valuation}()},
\code{\link{rad2deg}()}
}
\concept{Miscellaneous Functions}
