% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_means}
\alias{umx_means}
\title{umx_means}
\usage{
umx_means(df, ordVar = 0, na.rm = TRUE)
}
\arguments{
\item{df}{a dataframe of raw data from which to get variances.}

\item{ordVar}{value to return for the means of factor data = 0}

\item{na.rm}{passed to mean - defaults to "na.rm"}
}
\value{
- frame of means
}
\description{
Helper to get means from a df that might contain ordered or string data.
Factor means are set to "ordVar"
}
\examples{
tmp = mtcars[,1:4]
tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$hp  = ordered(mtcars$hp)  # binary factor
umx_means(tmp, ordVar = 0, na.rm = TRUE)
}
\seealso{
Other Miscellaneous Stats Helpers: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
