% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainUCDP.R
\name{uncertainUCDP_parameters}
\alias{uncertainUCDP_parameters}
\title{Parameter extraction for uncertainUCDP-functions}
\usage{
uncertainUCDP_parameters(fatalities, tov)
}
\arguments{
\item{fatalities}{A vector of non-negative integers representing the number of fatalities of the UCDP event. Non-integer values are allowed but should be considered experimental}

\item{tov}{A character string or integer value representing the type of violence of the UCDP. Must be one of "sb", "ns", "os", or "any" or their numeric equivalent The options are:

* "sb" or 1 for state-based violence
* "ns" or 2 for non-state violence
* "os" or 3 for one-sided violence
* "any" or 4 for parameters estimated across all type of violence. This is somewhat experimental and should be used with caution. This is possibly useful when the type of violence is unknown or when the user wants to combine all types of violence into a single category.}
}
\value{
A list with three elements: loc, scale, and w. loc and scale are the location and scale parameters of the Gumbel distribution, respectively. w is the weight parameter for the reported-value inflation
}
\description{
Extracting parameters for the reported-value inflated Gumbel mixture distribution for UCDP events. Primarily intended for internal use by the uncertainUCDP-functions, but can be used to extract parameters for the distribution manually.
}
