% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unfolding.R
\name{setbreaks}
\alias{setbreaks}
\title{Break vectors}
\usage{
setbreaks(nclass, maxSize, base = NULL, kap = 1, sizeType = c("linear",
  "exp"))
}
\arguments{
\item{nclass}{number of classes}

\item{maxSize}{maximum of \code{size} values}

\item{base}{constant for size class construction}

\item{kap}{constant for shape class construction}

\item{sizeType}{either \code{linear} or \code{exp}, default is \code{linear}}
}
\value{
list of class limits vectors
}
\description{
Construct class limits vectors
}
\details{
The function constructs the class limits for the size, shape and orientation parameters.
One can either define \code{linear} class limits of 'size' as
\eqn{a_i=i\delta, \delta=maxSize/M } or using exponentially increasing limits: \eqn{base^i, i=1,\dots,M}.
The orientation classes are defined as \eqn{\theta_j=j\omega, \omega=\pi/(2N), j=1,\dots,N} in the range
\eqn{[0,\pi/2]}, where \eqn{M,N} are the number of size classes and the number of orientation classes, respectively.
Argument \code{base} must not be \code{NULL} if \code{sizeType} equals "exp".
}
