% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{intersectSystem}
\alias{intersectSystem}
\title{Intersection in 3D}
\usage{
intersectSystem(S, d, n = c(0, 1, 0), intern = FALSE, pl = 0)
}
\arguments{
\item{S}{list of spheres, spheroids or spherocylinders, see \code{\link{simPoissonSystem}}}

\item{d}{distance of the the box-aligned intersecting plane from the origin}

\item{n}{normal vector which defines the intersecting plane}

\item{intern}{logical, \code{FALSE} (default), return all section profiles otherwise
   only those which have their centers inside the corresponding intersection window
(if the intersected system had been simulated using exact simulation this makes sense)}

\item{pl}{integer, \code{pl=0} (default), for no verbose output and otherwise a full specification list of
section profiles in case of sphere and spheroid intersections}
}
\value{
For spheroid intersections the function returns a list of size, shape and angle of section profiles or a short version
				of it; for sphere intersections either radii or lists containing the centers of discs and the object number.
}
\description{
Intersect a system of spheres, spheroids or spherocylinders by a plane
}
\details{
The function intersects a given (Poisson) system made of spheres, spheroids or cylinders as grains by a plane defined by a
normal vector, e.g. \code{n=c(0,1,0)}, perpendicular to one of the bounding planes of the simulation box. 
For a print level \code{pl>=0} some verbose output is given. Also it sets the type of return value. In case of spheroid
intersections, setting \code{pl=10}, leads to a short version of the full specification return list of section profiles
with elements named \code{A} (major semi-axis), \code{C} (minor semi-axis), \code{S} (the shape factor as the ratio of these two)
and \code{phi} as the angle in the intersecting plane between \eqn{[0,2\pi]} w.r.t. the 'x' axis. Otherwise additional components
are returned such as the ellipse`s rotation matrix, also named \code{A}, the center point \code{center} and a constant \code{type=10}
(defining the object of full ellipses among other types of intersection objects) of the section profiles. For sphere intersections only
a numeric vector of disc radii are returned as a short version of return values.
}
\examples{
 box <- list("xrange"=c(0,5),"yrange"=c(0,5),"zrange"=c(0,5))
 
 # constant size-shape orientation distribution (spheroids)
 theta <- list("size"=list(0.1),"shape"=list(0.5), "orientation"=list("kappa"=10))

 S <- simPoissonSystem(theta,lam=100,box=box,type="prolate",pl=1)
 
 # return short version of section profiles
 sp <- intersectSystem(S, 2.5, pl=10)		

}
\author{
M. Baaske
}
