% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FU_Berlin.R
\docType{data}
\name{fu_1}
\alias{fu_1}
\title{Primary color gradient of the Free University (FU) Berlin, Germany}
\format{
An object of class \code{character} of length 11.
}
\source{
Color definitions are based on 
\url{https://www.fu-berlin.de/sites/corporate-design/grundlagen/farben/index.html}.
}
\usage{
fu_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{fu_1} provides a gradient of the two primary colors 
of the \href{https://www.fu-berlin.de/en/index.html}{Free University Berlin}, Germany.
}
\details{
See \code{\link{fu_0}} for the two primary colors and 
the \code{\link{ac}} or \code{\link{usecol}} functions for creating 
alternative color gradients.
}
\examples{
fu_1
unikn::seecol(fu_1, main = "Primary color gradient of the FU Berlin")  # view color palette
unikn::demopal(fu_1, type = 4, seed = 2, main = "Primary color gradient of the FU Berlin")

}
\seealso{
\code{\link{fu_0}} for primary colors of the FU Berlin;
\code{\link{fu_2}} for secondary colors of the FU Berlin; 
\code{\link{fu_3}} for a blue color gradient of the FU Berlin;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_1}},
\code{\link{hu_2_2022}},
\code{\link{hu_2}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-03.
}
\concept{German university color palettes}
\keyword{datasets}
