% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Manchester.R
\docType{data}
\name{uni_manchester}
\alias{uni_manchester}
\title{Primary colours of the University of Manchester, England, UK}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on the
\href{https://www.staffnet.manchester.ac.uk/brand/visual-identity/colour/}{Manchester's visual identity}.
}
\usage{
uni_manchester
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{uni_manchester} provides the three primary colours 
of the \href{https://www.manchester.ac.uk}{University of Manchester}, England, UK.
}
\details{
The three primary colours are
\code{"Purple"} (defined as C72 M100 Y0 K0, R109 G0 B157, HEX #660099),
\code{"Yellow"} (defined as C0 M15 Y100 K0, R255 G204 B51, HEX #FFCC33), and
\code{"Grey"} (defined as C0 M0 Y0 K50, R149 G149 B151, HEX #999999).

The purple should be used as a main colour with the grey and yellow to complement it. 

\code{uni_manchester} uses the HEX color definitions. 
#' RGB color values differ from HEX definition.
For \code{"Purple"} and \code{"Grey"} the RGB and HEX definitions differ numerically, 
yet are visually indistinguishable. Our color palette is based on the HEX definition.

Note that the \href{https://www.manchester.ac.uk}{University of Manchester} is located in England / UK. 
and not to be confused with \href{https://www.manchester.edu}{Manchester University}, located in Indiana, USA.
}
\examples{
uni_manchester
unikn::seecol(uni_manchester, main = "University of Manchester, UK") # view color palette

}
\seealso{
\code{\link{manchester_uni_1}} for primary colors of Manchester University, IN, USA; 
\code{\link{manchester_uni_2}} for accent colours of Manchester University, IN, USA; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{English university color palettes}
\keyword{datasets}
