% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_kiel_2}
\alias{uni_kiel_2}
\title{Departmental colors of Kiel University}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\url{https://www.presse.uni-kiel.de/de/erscheinungsbild/farben}.
}
\usage{
uni_kiel_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_kiel_2} provides the 8 departmental colors (German "Fakultäten") 
of \href{https://www.uni-kiel.de/en/}{Kiel University}, Germany.
}
\details{
These colors may be mixed with darker shades of \code{"grey"} (or \code{"black"}). 
See examples and the \code{\link{ac}} and \code{\link{usecol}} functions 
for creating color gradients. 

The full name of \href{https://www.uni-kiel.de/en/}{Kiel University} 
is Christian-Albrechts-Universität (CAU) zu Kiel.
}
\examples{
uni_kiel_2
seecol(uni_kiel_2, main = "Departmental colors of Kiel University (CAU)")
demopal(uni_kiel_2, type = 3, main = "Department colors of the University of Kiel")

# Gradients: Mix with "black" for darker shades:
uni_kiel_med <- usecol(c(uni_kiel_2["Medizin"], "black"), n = 5)
seecol(uni_kiel_med, main = "5 shades of 'Medizin' of Uni Kiel")

}
\seealso{
\code{\link{uni_kiel_1}} for primary colors of Kiel University;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2023-01-02.
}
\concept{contributed color palettes}
\keyword{datasets}
