% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.unitquantreg}
\alias{plot.unitquantreg}
\title{Plot method for \code{unitquantreg} objects}
\usage{
\method{plot}{unitquantreg}(
  x,
  which = 1L:4L,
  caption = c("Residuals vs. indices of obs.", "Residuals vs. linear predictor",
    "Working response vs. linear predictor", "Half-normal plot of residuals"),
  sub.caption = paste(deparse(x$call), collapse = "\\n"),
  main = "",
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  ...,
  add.smooth = getOption("add.smooth"),
  type = "quantile",
  nsim = 99L,
  level = 0.95
)
}
\arguments{
\item{x}{fitted model object of class \code{unitquantreg}.}

\item{which}{integer. if a subset of the plots is required, specify a subset
of the numbers 1 to 4, see below for further details.}

\item{caption}{character. Captions to appear above the plots.}

\item{sub.caption}{character. Common title-above figures if there are multiple.}

\item{main}{character. Title to each plot in addition to the above caption.}

\item{ask}{logical. If \code{TRUE}, the user is asked before each plot.}

\item{...}{other parameters to be passed through to plotting functions.}

\item{add.smooth}{logical. Indicates if a smoother should be added to most plots}

\item{type}{character. Indicates type of residual to be used, see
\code{\link{residuals.unitquantreg}}.}

\item{nsim}{integer. Number of simulations in half-normal plots, see
\code{\link{hnp.unitquantreg}}.}

\item{level}{numeric. Confidence level of the simulated envelope, see
\code{\link{hnp.unitquantreg}}.}
}
\value{
No return value, called for side effects.
}
\description{
Provide diagnostic plots to check model assumptions for fitted model
of class \code{unitquantreg}.
}
\details{
The \code{plot} method for \code{unitquantreg} objects produces four types
of diagnostic plot.

The \code{which} argument can be used to select a subset of currently four
supported plot, which are: Residuals versus indices of observations
(\code{which = 1}); Residuals versus linear predictor (\code{which = 2});
Working response versus linear predictor (\code{which = 3}) to
check possible misspecification of link function; Half-normal plot of
residuals (\code{which = 4}) to check distribution assumption.
}
\references{
Dunn, P. K. and Smyth, G. K. (2018) Generalized Linear Models With Examples in R, Springer, New York.
}
\seealso{
\code{\link{residuals.unitquantreg}},
\code{\link{hnp.unitquantreg}},
\code{\link{unitquantreg}}.
}
\author{
André F. B. Menezes
}
