% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_conversion.R
\name{install_conversion_function}
\alias{install_conversion_function}
\title{Install a function for conversion between user-defined units.}
\usage{
install_conversion_function(from, to, f)
}
\arguments{
\item{from}{String for the symbol of the unit being converted from.}

\item{to}{String for the symbol of the unit being converted to.}

\item{f}{A function responsible for conversion.}
}
\description{
Tells the \code{units} package how to convert one-way from one 
  unit to another.
}
\details{
This is the most general way of specifying conversion between 
  user-defined units. The function installes a one-way conversion from one
  unit to another through a general function, \code{f}, that must take one
  numeric argument and return one numeric argument. When the \code{units}
  package tries to convert between units, it will look up \code{from} and
  \code{to} to see if it can find a conversion function. If it can, it will
  call \code{f} and consider the value converted from unit \code{from} to
  unit \code{to}.
  
  It is the user's responsibility to install a conversion from \code{to} back
  to \code{from} as well. One-way conversion does not work well with the 
  \code{units} package, since conversion is done in several places for unit 
  expression simplification and if a unit can only be converted in one 
  direction, this simplification will not work correctly.
  
  For conversion that can be done as a linear function, \eqn{y = \alpha x +
  \beta}, you should instead use the
  \code{\link{install_conversion_constant}} function. This function will
  automatically install conversion functions for both directions of unit
  conversion.
}
\examples{

apples <- 2 * make_unit("apple")
oranges <- 3 * make_unit("orange")
# one orange is worth two apples
install_conversion_function("orange", "apple", function(x) 2 * x)
install_conversion_function("apple", "orange", function(x) x / 2)
apples + oranges
oranges + apples

}
\seealso{
\code{\link{install_conversion_constant}}
}
