% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhead.R
\name{enhead}
\alias{enhead}
\title{Join data cells to headers}
\usage{
enhead(data_cells, header_cells, direction, drop = TRUE)
}
\arguments{
\item{data_cells}{Data frame of data cells with at least the columns 'row'
and 'column', which are \code{numeric} or \code{integer}.}

\item{header_cells}{Data frame of header cells with at least the columns
'row' and 'column', which are numeric/integer vectors.}

\item{direction}{The direction between a data cell and its header, one of
\code{"up"}, \code{"right"}, \code{"down"}, \code{"left"}, \code{"up-left"}, \code{"up-right"},
\code{"right-up"}, \code{"right-down"}, \code{"down-right"}, \code{"down-left"}, \code{"left-down"},
\code{"left-up"}, \code{"up-ish"}, \code{"down-ish"}, \code{"left-ish"} and \code{"right-ish"}. See
\code{?direction}.}

\item{drop}{Logical vector length 1. Whether data cells that can't be
associated with a header should be dropped.  Default: \code{TRUE}.}
}
\description{
Data cells in a table are associated with header cells by proximity.
\code{\link[=enhead]{enhead()}} joins a data frame of data cells to a data frame of header cells,
choosing the nearest header cells in the given direction.  See \code{?direction}.
}
\examples{
library(dplyr)
# Load some pivoted data
(x <- purpose$`up-left left-up`)
# Make a tidy representation
cells <- as_cells(x)
cells <- cells[!is.na(cells$chr), ]
head(cells)
# Select the cells containing the values
data_cells <-
  filter(cells, row >= 3, col >= 3) \%>\%
  transmute(row, col, count = as.integer(chr))
head(data_cells)
# Select the headers
qualification <-
  filter(cells, col == 1) \%>\%
  select(row, col, qualification = chr)
age <-
  filter(cells, col == 2) \%>\%
  select(row, col, age = chr)
gender <-
  filter(cells, row == 1) \%>\%
  select(row, col, gender = chr)
satisfaction <-
  filter(cells, row == 2) \%>\%
  select(row, col, satisfaction = chr)
# From each data cell, search for the nearest one of each of the headers
data_cells \%>\%
  enhead(gender, "up-left") \%>\%
  enhead(satisfaction, "up") \%>\%
  enhead(qualification, "left-up") \%>\%
  enhead(age, "left") \%>\%
  select(-row, -col)

# The `drop` argument controls what happens when for some cells there is no
# header in the given direction. When `drop = TRUE` (the default), cells that
# can't be joined to a header are dropped.  Otherwise they are kept.
enhead(data_cells, gender, "up")
enhead(data_cells, gender, "up", drop = FALSE)
}
