% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oracle.R
\name{oracle_mis_from_joint}
\alias{oracle_mis_from_joint}
\title{Get the oracle misclassification error rate directly from the
joint distribution of the genotype and the oracle estimator.}
\usage{
oracle_mis_from_joint(jd)
}
\arguments{
\item{jd}{A matrix of numerics. Element (i, j) is the probability
of genotype i - 1 and estimated genotype j - 1. This is usually
obtained from \code{\link{oracle_joint}}.}
}
\value{
A double. The oracle misclassification error rate.
}
\description{
Get the oracle misclassification error rate directly from the
joint distribution of the genotype and the oracle estimator.
}
\examples{
## Hardy-Weinberg population with allele-frequency of 0.75.
## Moderate bias and moderate overdispersion.
ploidy <- 6
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
jd <- oracle_joint(n = 100, ploidy = ploidy, seq = 0.001,
                   bias = 0.7, od = 0.01, dist = dist)
oracle_mis_from_joint(jd = jd)

## Compare to oracle_cor
oracle_mis(n = 100, ploidy = ploidy, seq = 0.001,
           bias = 0.7, od = 0.01, dist = dist)

}
\seealso{
\code{\link{oracle_joint}} for getting \code{jd}.
    \code{\link{oracle_mis}} for not having to first calculate
    \code{jd}.
}
\author{
David Gerard
}
