% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearch_parsers.R
\name{unpack_nested_data}
\alias{unpack_nested_data}
\title{Unpack a nested data.table}
\usage{
unpack_nested_data(chomped_df, col_to_unpack)
}
\arguments{
\item{chomped_df}{a data.table}

\item{col_to_unpack}{a character vector of length one: the column name to 
unpack}
}
\description{
After calling a \code{chomp_*} function or \code{es_search}, if 
  you had a nested array in the JSON, its corresponding column in the 
  resulting data.table is a data.frame itself (or a list of vectors). This 
  function expands that nested column out, adding its data to the original 
  data.table, and duplicating metadata down the rows as necessary.
  
  This is a side-effect-free function: it returns a new data.table and the
  input data.table is unmodified.
}
\examples{
# A sample raw result from a hits query:
result <- '[{"_source":{"timestamp":"2017-01-01","cust_name":"Austin","details":{
"cust_class":"big_spender","location":"chicago","pastPurchases":[{"film":"The Notebook",
"pmt_amount":6.25},{"film":"The Town","pmt_amount":8.00},{"film":"Zootopia","pmt_amount":7.50,
"matinee":true}]}}},{"_source":{"timestamp":"2017-02-02","cust_name":"James","details":{
"cust_class":"peasant","location":"chicago","pastPurchases":[{"film":"Minions",
"pmt_amount":6.25,"matinee":true},{"film":"Rogue One","pmt_amount":10.25},{"film":"Bridesmaids",
"pmt_amount":8.75},{"film":"Bridesmaids","pmt_amount":6.25,"matinee":true}]}}},{"_source":{
"timestamp":"2017-03-03","cust_name":"Nick","details":{"cust_class":"critic","location":"cannes",
"pastPurchases":[{"film":"Aala Kaf Ifrit","pmt_amount":0,"matinee":true},{
"film":"Dopo la guerra (Apres la Guerre)","pmt_amount":0,"matinee":true},{
"film":"Avengers: Infinity War","pmt_amount":12.75}]}}}]'

# Chomp into a data.table
sampleChompedDT <- chomp_hits(hits_json = result, keep_nested_data_cols = TRUE)
print(sampleChompedDT)

# (Note: use es_search() to get here in one step)

# Unpack by details.pastPurchases
unpackedDT <- unpack_nested_data(chomped_df = sampleChompedDT
                                 , col_to_unpack = "details.pastPurchases")
print(unpackedDT)
}
