% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_matrix.R
\name{dist_to_centroids}
\alias{dist_to_centroids}
\title{Compute distances from each item to group centroids}
\usage{
dist_to_centroids(d, g)
}
\arguments{
\item{d}{A distance matrix object of class `"dist"`.}

\item{g}{A factor representing the groups of items in `d`.}
}
\value{
A data frame with distances to the group centroids (see details).

This function computes the distance from each item to the centroid positions
of groups defined in the argument `g`.  This is accomplished without
determining the centroid positions directly; see the documentation for
\code{\link{dist_between_centroids}} for details on this procedure.

The result is a data frame with three columns:

\describe{
  \item{Item}{
    A character vector of item labels from the dist object, or an integer
    vector of item locations if labels are not present.}
  \item{CentroidGroup}{
    The group for which the centroid distance is given. The column type
    should match that of the argument g (the \code{unique} function is used
    to generate this column).}
  \item{CentroidDistance}{
    Inferred distance from the item to the centroid position of the
    indicated group.}}
}
\description{
Compute distances from each item to group centroids
}
