% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_row.R
\name{build_row.factor}
\alias{build_row.factor}
\title{Summarize factor data}
\usage{
\method{build_row}{factor}(
  x,
  y = NA,
  label = "(Unlabeled column)",
  parametric = FALSE,
  na.rm = FALSE,
  append.stat = TRUE,
  show.missing = FALSE,
  show.test = FALSE,
  percent.sign = TRUE,
  digits = 1,
  p.digits = 4,
  ...
)
}
\arguments{
\item{x}{A factor. Data to summarize. Must be the same length as \code{y}
(if specified).}

\item{y}{A factor or logical. Optional. Data to stratify \code{x} by.}

\item{label}{A character. Optional. The name of the summarized variable.}

\item{parametric}{A logical. Optional. Use parametric tests.}

\item{na.rm}{A logical. Optional. Whether to ignore NA values in frequency
calculations. If left unspecified, NA values will be given an explicit level
and summarized.}

\item{append.stat}{A logical. Optional. Append the summary statistic used to
the label of the summarized row.}

\item{show.missing}{A logical. Optional. Append summary counts of missing
data.}

\item{show.test}{A logical. Optional. Show the statistical test and test
statistic used to determine the p-value.}

\item{percent.sign}{A logical. Optional. Paste a percentage symbol with each
frequency.}

\item{digits}{An integer. Optional. Number of digits to round to.}

\item{p.digits}{An integer. Optional. Number of p-value digits to report.}

\item{...}{Miscellaneous options.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} summarizing the
provided data.
}
\description{
Summarize factor data in a tibble. Optional stratification and
null hypothesis testing using another factor or logical.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

# Create a row summarizing a factor by a factor
build_row(x = data_mtcars$carb, y = data_mtcars$cyl)
}
\seealso{
\code{\link{build_row}}
}
