% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_model.coxph}
\alias{tabulate_model.coxph}
\title{Tabulate Model: Cox PH}
\usage{
\method{tabulate_model}{coxph}(fit, format = TRUE, percent.sign = TRUE,
  digits = 1, p.digits = 4)
}
\arguments{
\item{fit}{Required. survival::coxph() object.}

\item{format}{Optional. Logical. Rounds numbers and formats text for a
cleaner, readable output. Defaults to TRUE.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note that
p-values are still rounded using 'digits'. Defaults to 4.}
}
\description{
Converts parameters from a cox parametric hazards model
into a usable table for publication purposes.
}
\examples{
library(survival)
library(dplyr)

# Survival data
data_lung <- lung \%>\%
  as_tibble() \%>\%
  mutate_at(vars(inst, status, sex), as.factor) \%>\%
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

tabulate_model(
  fit = coxph(Surv(time, status) ~ sex + meal.cal + inst, data = data_lung)
 )
}
\seealso{
\code{\link{tabulate_model}}
}
