% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ctrl.R
\name{predict.CTRLmodel}
\alias{predict.CTRLmodel}
\title{Predict Method for CTRL}
\usage{
\method{predict}{CTRLmodel}(object, newdata, vote.schema = "maj",
  probability = getOption("utiml.use.probs", TRUE), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed",
  NA))
}
\arguments{
\item{object}{Object of class '\code{CTRLmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{vote.schema}{Define the way that ensemble must compute the predictions.
The default valid options are: c("avg", "maj", "max", "min").
(Default: \code{'maj'})}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by
\code{\link{ctrl}}.
}
\examples{
\dontrun{
model <- ctrl(toyml, "RANDOM")
pred <- predict(model, toyml)

# Predict SVM bipartitions running in 6 cores
pred <- predict(model, toyml, probability = FALSE, cores = 6)

# Using the Maximum vote schema
pred <- predict(model, toyml, vote.schema = 'max')
}
}
\seealso{
\code{\link[=ctrl]{CTRL}}
}
