% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_time_to_event.R
\name{get_time_to_event_at}
\alias{get_time_to_event_at}
\title{Construct Time-to-Event at}
\usage{
get_time_to_event_at(
  data_set,
  outcome_date_col,
  censoring_date_col,
  end_cohort,
  at
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{end_cohort}{End date of the study.}

\item{at}{Time to truncate the follow-up period}
}
\value{
\code{data.frame} containing time_to_event and outcome_status
}
\description{
This function returns both the time-to-event until a
reference number of days, as provided in \code{at}, and the outcome status
at the same point. It uses the exposure time as an auxiliary variable
to calculate the time-to-event. The starting point for counting the
time-to-event is \code{t0_follow_up}, which is determined based on whether
a matching strategy is used or not. If the event occurs before the
reference date, the end date of the exposure period is used to
calculate the time-to-event. This accounts for whether censoring or an
event occurred. The outcome status is determined based on whether the
outcome date coincides with the end of the follow-up period.
}
\keyword{internal}
