% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/barplot.R
\docType{methods}
\name{barplot,validation-method}
\alias{barplot,validation-method}
\title{Plot number of violations}
\usage{
\S4method{barplot}{validation}(height, ..., order_by = c("fails", "passes",
  "nNA"), stack_by = c("fails", "passes", "nNA"), topn = Inf,
  add_legend = TRUE, add_exprs = TRUE, colors = c(fails = "#FC8D59",
  passes = "#91CF60", nNA = "#FFFFBF"))
}
\arguments{
\item{height}{an R object defining height of bars (here, a \code{validation} object)}

\item{...}{parameters to be passed to \code{\link[graphics]{barplot}} but not
\code{height}, \code{horiz}, \code{border},\code{las}, and \code{las}.}

\item{order_by}{(single \code{character}) order bars decreasingly from top to bottom by the
number of fails, passes or \code{NA}'s.}

\item{stack_by}{(3-vector of \code{characters}) Stacking order for bar chart (left to right)}

\item{topn}{If specified, plot only the top n most violated calls}

\item{add_legend}{Display legend?}

\item{add_exprs}{Display rules?}

\item{colors}{Bar colors for validations yielding NA or a violation}
}
\value{
A list, containing the bar locations as in \code{\link[graphics]{barplot}}
}
\description{
Plot number of violations
}
\section{Credits}{

The default colors were generated with the \code{RColorBrewer} package of Erich Neuwirth.
}
\examples{
data(retailers)
cf <- check_that(retailers
    , staff.costs < total.costs
    , turnover + other.rev == total.rev
    , other.rev > 0
    , total.rev > 0)
barplot(cf)

}
\seealso{
\itemize{
 \item{\code{\link{summary,validation-method}}}
 \item{\code{\link{aggregate,validation-method}}}
 \item{\code{\link{sort,validation-method}}}
 \item{\code{\link{validation}}}
}
}

