# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Validate a JSON file against a JSON Schema file
#' 
#' Description
#' @param jsonfn The JSON file 
#' @param schemafn The JSON Schema file
#' This function will check that the supplied files are not empty and are accessible
#' and it will then validate that the JSON file is valid (and well formed) against the
#' supplied schema file. Currently only version 4 of the JSON schema is supported.
#' @examples
#' \dontrun{
#' validate_jsonfile_with_schemafile("data/item-3.json", "data/schema.json")
#' }
#' @export
#' @useDynLib validatejsonr
#' @importFrom Rcpp evalCpp
validate_jsonfile_with_schemafile <- function(jsonfn, schemafn) {
    .Call('validatejsonr_validate_jsonfile_with_schemafile', PACKAGE = 'validatejsonr', jsonfn, schemafn)
}

#' Validate a JSON string against a JSON Schema file
#' 
#' Description
#' @param json_string The JSON code 
#' @param schemafn The JSON Schema file
#' This function will check that the supplied schema file is not empty and is accessible
#' and it will then validate that the JSON code is valid (and well formed) against the
#' supplied schema file.
#' @examples
#' \dontrun{
#' json_code <- "{\"category\": \"book\", \"price\": 25,  \"title\": \"abrakadabra\"}"
#' validate_json_with_schemafile(json_code, "data/schema.json")
#' }
#' @export
#' @useDynLib validatejsonr
#' @importFrom Rcpp evalCpp
validate_json_with_schemafile <- function(json_string, schemafn) {
    .Call('validatejsonr_validate_json_with_schemafile', PACKAGE = 'validatejsonr', json_string, schemafn)
}

#' Validate a JSON file against a JSON Schema string
#' 
#' Description
#' @param jsonfn The JSON file 
#' @param schema_string The JSON Schema string
#' This function will check that the supplied schema is not empty and it will then validate
#' that the JSON file is accessible and valid (and well formed) w.r.t the supplied schema file.
#' @examples
#' \dontrun{
#' json_code <- "{\"category\": \"book\", \"price\": 25,  \"title\": \"abrakadabra\"}"
#' validate_json_with_schemafile(json_code, "data/schema.json")
#' }
#' @export
#' @useDynLib validatejsonr
#' @importFrom Rcpp evalCpp
validate_jsonfile_with_schema <- function(jsonfn, schema_string) {
    .Call('validatejsonr_validate_jsonfile_with_schema', PACKAGE = 'validatejsonr', jsonfn, schema_string)
}

#' Validate a JSON string against a JSON Schema string
#' 
#' Description
#' @param json_string The JSON code 
#' @param schema_string The JSON Schema string
#' This function will check that the supplied schema is not empty and it will then validate 
#' that the JSON code is valid (and well formed) w.r.t the supplied schema.
#' @export
#' @useDynLib validatejsonr
#' @importFrom Rcpp evalCpp
validate_json_with_schema <- function(json_string, schema_string) {
    .Call('validatejsonr_validate_json_with_schema', PACKAGE = 'validatejsonr', json_string, schema_string)
}

