% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contradicted.R
\name{is_contradicted_by}
\alias{is_contradicted_by}
\title{Find out which rules are conflicting}
\usage{
is_contradicted_by(x, rule_name)
}
\arguments{
\item{x}{\code{\link{validator}} object with rules.}

\item{rule_name}{\code{character} with the names of the rules that are causing infeasibility.}
}
\value{
\code{character} with conflicting rules.
}
\description{
Find out for a contradicting rule which rules are conflicting. This helps in determining and assessing conflicts in rule sets. Which
of the rules should stay and which should go?
}
\examples{
rules <- validator( x > 0)

is_infeasible(rules)

rules <- validator( rule1 = x > 0
                  , rule2 = x < 0
                  )

is_infeasible(rules)

detect_infeasible_rules(rules)
make_feasible(rules)

# find out the conflict with this rule
is_contradicted_by(rules, "rule1")
}
\seealso{
Other feasibility: \code{\link{detect_boundary_cat}},
  \code{\link{detect_boundary_num}},
  \code{\link{detect_infeasible_rules}},
  \code{\link{is_infeasible}}, \code{\link{make_feasible}}
}
