% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_intersect.r
\name{bed_intersect}
\alias{bed_intersect}
\title{Identify intersecting intervals.}
\usage{
bed_intersect(x, y, invert = FALSE, suffix = c(".x", ".y"), ...)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{invert}{report \code{x} intervals not in \code{y}}

\item{suffix}{colname suffixes in output}

\item{...}{extra arguments (not used)}
}
\description{
Identify intersecting intervals.
}
\details{
input tbls can be grouped using \code{\link[dplyr]{group_by}} prior to 
  analysis. Input tbls are grouped by \code{chrom} by default. Grouping by 
  \code{strand} will constrain analyses to the same strand. To compare 
  opposing strands between two tbls, strands on the \code{y} tbl can first be
  be inverted using \code{\link{flip_strands}}.
}
\note{
Book-ended intervals have \code{.overlap} values of 0 in the output.
}
\examples{
x <- tibble::tribble(
~chrom, ~start, ~end,
'chr1', 25,      50,
'chr1', 100,     125
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1', 30,     75
)

bed_glyph(bed_intersect(x, y))
bed_glyph(bed_intersect(x, y, invert = TRUE))

x <- tibble::tribble(
~chrom, ~start, ~end,
"chr1", 100,    500,
"chr2", 200,    400,
"chr2", 300,    500,
"chr2", 800,    900
)

y <- tibble::tribble(
~chrom, ~start, ~end, ~value,
"chr1", 150,    400,  100,
"chr1", 500,    550,  100,
"chr2", 230,    430,  200,
"chr2", 350,    430,  300
)

bed_intersect(x, y)
 
}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/intersect.html}

Other multi-set-ops: \code{\link{bed_closest}},
  \code{\link{bed_coverage}}, \code{\link{bed_map}},
  \code{\link{bed_subtract}}, \code{\link{bed_window}}
}

