% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_absdist.r
\name{bed_absdist}
\alias{bed_absdist}
\title{Compute absolute distances between intervals.}
\usage{
bed_absdist(x, y, genome)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}} with \code{.absdist} and \code{.absdist_scaled}
columns.
}
\description{
Computes the absolute distance between the midpoints of \code{x} intervals and
the closest midpoints of \code{y} intervals.
}
\details{
Absolute distances are scaled by the inter-reference gap for the
chromosome as follows. For \code{Q} query points and \code{R} reference
points on a chromosome, scale the distance for each query point \code{i} to
the closest reference point by the inter-reference gap for each chromosome.
If an \code{x} interval has no matching \code{y} chromosome,
\code{.absdist} is \code{NA}.

\deqn{d_i(x,y) = min_k(|q_i - r_k|)\frac{R}{Length\ of\ chromosome}}

Both absolute and scaled distances are reported as \code{.absdist} and
\code{.absdist_scaled}.

Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
x <- trbl_interval(
  ~chrom,   ~start,    ~end,
  "chr1",    75,       125
)

y <- trbl_interval(
  ~chrom,   ~start,    ~end,
  "chr1",    50,       100,
  "chr1",    100,       150
)

genome <- trbl_genome(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_absdist(x, y, genome)

}
\seealso{
\url{http://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1002529}

Other interval statistics: \code{\link{bed_fisher}},
  \code{\link{bed_jaccard}}, \code{\link{bed_projection}},
  \code{\link{bed_reldist}}
}
