% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectVariables.R
\name{selectVariables}
\alias{selectVariables}
\title{selectVariables}
\usage{
selectVariables(
  phiInit,
  rhoInit,
  piInit,
  gamInit,
  mini,
  maxi,
  gamma,
  glambda,
  X,
  Y,
  thresh = 1e-08,
  eps,
  ncores = 3,
  fast
)
}
\arguments{
\item{phiInit}{an initial estimator for phi (size: p*m*k)}

\item{rhoInit}{an initial estimator for rho (size: m*m*k)}

\item{piInit}{an initial estimator for pi (size : k)}

\item{gamInit}{an initial estimator for gamma}

\item{mini}{minimum number of iterations in EM algorithm}

\item{maxi}{maximum number of iterations in EM algorithm}

\item{gamma}{power in the penalty}

\item{glambda}{grid of regularization parameters}

\item{X}{matrix of regressors}

\item{Y}{matrix of responses}

\item{thresh}{real, threshold to say a variable is relevant, by default = 1e-8}

\item{eps}{threshold to say that EM algorithm has converged}

\item{ncores}{Number or cores for parallel execution (1 to disable)}

\item{fast}{boolean to enable or not the C function call}
}
\value{
a list, varying lambda in a grid, with selected (the indices of variables that are selected),
Rho (the covariance parameter, reparametrized), Pi (the proportion parameter)
}
\description{
For a given lambda, construct the sets of relevant variables for each cluster.
}
