% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step2_ScenarioGeneration.R
\name{genIndexScen}
\alias{genIndexScen}
\title{Simulate a 3D array, numScen by numIndex by numStep, of Black-Scholes return
factors for numIndex indices in each of numStep time steps and each of
numScen scenarios. Covariances among indices are specified in covMatrix.
Stepsize is given is dT and interpolated discount factors are given in vDF.
Random seed is optional for reproducibility.}
\usage{
genIndexScen(covMatrix, numScen, numStep, indexNames, dT, forwardCurve,
  seed)
}
\arguments{
\item{covMatrix}{A numIndex-by-numIndex matrix of doubles of covariances
among numIndex indices.}

\item{numScen}{An integer of number of scenario (sample paths) to be
simulated.}

\item{numStep}{An integer of number of periods to be simulated.}

\item{indexNames}{A vector of strings containing index names.}

\item{dT}{A double of stepsize in years; dT = 1 / 12 would be monthly.}

\item{forwardCurve}{A vector of doubles of discount rates at each time step.}

\item{seed}{An integer of the deterministic seed for random sampling.}
}
\value{
Outputs a 3D array (numScen-by-numStep-by-numIndex) of index
  scenarios
}
\description{
Simulate a 3D array, numScen by numIndex by numStep, of Black-Scholes return
factors for numIndex indices in each of numStep time steps and each of
numScen scenarios. Covariances among indices are specified in covMatrix.
Stepsize is given is dT and interpolated discount factors are given in vDF.
Random seed is optional for reproducibility.
}
\examples{
genIndexScen(mCov, 100, 360, indexNames, 1 / 12, cForwardCurve, 1)
}
