## Dataset_documentation.R :: dataset documentation
##
## jul-28-2017 (exe) created
## aug-02-2017 (exe) added thrombin10.PDBs.align
##
## Please direct all questions to Emilio Xavier Esposito, PhD
## exeResearch LLC, East Lansing, Michigan 48823 USA
## http://www.exeResearch.com
## emilio AT exeResearch DOT com
## emilio DOT esposito AT gmail DOT com
##
## Copyright (c) 2017, Emilio Xavier Esposito
##
## Permission is hereby granted, free of charge, to any person obtaining
## a copy of this software and associated documentation files (the
## "Software"), to deal in the Software without restriction, including
## without limitation the rights to use, copy, modify, merge, publish,
## distribute, sublicense, and/or sell copies of the Software, and to
## permit persons to whom the Software is furnished to do so, subject to
## the following conditions:
##
## The above copyright notice and this permission notice shall be
## included in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
## EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
## MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
## NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
## OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
## WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
##
## Based on http://opensource.org/licenses/MIT
##


## PDB.1ecd docs ---------------------------------------------------------------
#' @title PDB Structure of Erythrocruorin
#' @description Structure of erythrocruorin in different ligand states refined
#'   at 1.4 A resolution.
#' @details The 3D structure of erythrocruorin in different ligand states
#'   refined at 1.4 A resolution. This 3D structure was downloaded from the
#'   [RCSB](http://www.rcsb.org/pdb/explore/explore.do?structureId=1ecd) and
#'   read into `R` using [bio3d::read.pdb()]. It is used in examples and
#'   testing.
#'
#' @name PDB.1ecd
#'
#' @author Emilio Xavier Esposito \email{emilio@@exeResearch.com}
#'
#' @references
#'   PDB ID: [1ecd](http://www.rcsb.org/pdb/explore/explore.do?structureId=1ecd)
#'   Wolfgang Steigemann and Ernst Weber. Structure of erythrocruorin in different
#'   ligand states refined at 1.4 A resolution. _Journal of Molecular Biology_,
#'   1979, **127** (_3_), pp 309-338.
#'   [DOI: 10.1016/0022-2836(79)90332-2](https://doi.org/10.1016/0022-2836(79)90332-2)
#'   [PMID: 430568](https://www.ncbi.nlm.nih.gov/pubmed/?term=430568)
#'
#'   HM Berman, J Westbrook, Z Feng, G Gilliland, TN Bhat, H Weissig, IN
#'   Shindyalov, PE Bourne. The Protein Data Bank. _Nucleic Acids Research_,
#'   2000, **28** (_1_), pp 235-242.
#'   [DOI: 10.1093/nar/28.1.235](https://doi.org/10.1093/nar/28.1.235)
#'   [PMCID: PMC102472](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC102472/)
#'
NULL


## PDB.5rxn docs ---------------------------------------------------------------
#' @title PDB Structure of Rubredoxin
#' @description Combined crystallographic refinement and energy minimization of
#'   rubredoxin at 1.2 Angstrom resolution.
#' @details The 3D structure of rubredoxin at 1.2 Angstrom resolution obtained
#'   via combined crystallographic refinement and energy minimization. This 3D
#'   structure was downloaded from the
#'   [RCSB](http://www.rcsb.org/pdb/explore/explore.do?structureId=5rxn) and
#'   read into `R` using [bio3d::read.pdb()]. It is used in examples and
#'   testing.
#'
#' @name PDB.5rxn
#'
#' @author Emilio Xavier Esposito \email{emilio@@exeResearch.com}
#'
#' @references
#'   PDB ID: [5rxn](http://www.rcsb.org/pdb/explore/explore.do?structureId=5rxn)
#'   Keith D Watenpaugh. Combined Crystallographic Refinement And Energy
#'   Minimization Of Rubredoxin At 1.2 Angstrom Resolution.
#'
#'   HM Berman, J Westbrook, Z Feng, G Gilliland, TN Bhat, H Weissig, IN
#'   Shindyalov, PE Bourne. The Protein Data Bank. _Nucleic Acids Research_,
#'   2000, **28** (_1_), pp 235-242.
#'   [DOI: 10.1093/nar/28.1.235](https://doi.org/10.1093/nar/28.1.235)
#'   [PMCID: PMC102472](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC102472/)
#'
NULL


## thrombin.1hai docs ----------------------------------------------------------
#' @title PDB Structure of Thrombin
#' @description Isomorphous structures of prethrombin2, hirugen-, and
#'   PPACK-thrombin.
#' @details The 3D structure of isomorphous structures of prethrombin2,
#'   hirugen-, and PPACK-thrombin at 2.4 Angstroms. This 3D structure was
#'   downloaded from the
#'   [RCSB](http://www.rcsb.org/pdb/explore/explore.do?structureId=1hai) and
#'   read into `R` using [bio3d::read.pdb()]. It is used in examples and
#'   testing.
#'
#' @name thrombin.1hai
#'
#' @author Emilio Xavier Esposito \email{emilio@@exeResearch.com}
#'
#' @references
#'   PDB ID: [1hai](http://www.rcsb.org/pdb/explore/explore.do?structureId=1hai)
#'   J Vijayalakshmi, KP Padmanabhan, KG Mann, and A Tulinsky. The isomorphous
#'   structures of prethrombin2, hirugen-, and PPACK-thrombin: changes
#'   accompanying activation and exosite binding to thrombin.. _Protein
#'   Science_, 1994, **3** (_12_), pp 2254–2271.
#'
#'   HM Berman, J Westbrook, Z Feng, G Gilliland, TN Bhat, H Weissig, IN
#'   Shindyalov, PE Bourne. The Protein Data Bank. _Nucleic Acids Research_,
#'   2000, **28** (_1_), pp 235-242.
#'   [DOI: 10.1002/pro.5560031211](https://dx.doi.org/10.1002/pro.5560031211)
#'   [PMCID: PMC2142772](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2142772)
#'
NULL





## thrombin10.PDBs.align docs --------------------------------------------------
#' @title Thrombin10 Vignette's Primary Sequence Alignment
#' @description Thrombin10 vignette's primary sequence alignment.
#' @details The primary sequence alignment is being provided because the CRAN
#'   servers where R packages are tested does not have the MUltiple Sequence
#'   Comparison by Log-Expectation (MUSCLE; [MUSCLE
#'   webpage](http://www.drive5.com/muscle/) and the [EBI
#'   webpage](http://www.ebi.ac.uk/Tools/msa/muscle/) application installed.
#'   This alignment of 10 thrombin structures for the Thrombin 10 Vignette
#'   allows the vignette to be completed without errors.
#'
#' @name thrombin10.PDBs.align
#'
#' @author Emilio Xavier Esposito \email{emilio@@exeResearch.com}
#'
#' @references
#'   RC Edgar. MUSCLE: multiple sequence alignment with high accuracy
#'   and high throughput. _Nucleic Acids Research_, 2004, **32** (_5_),
#'   pp 1792-1797. \cr
#'   [PMID: 15034147](http://www.ncbi.nlm.nih.gov/pubmed/15034147) \cr
#'   [PMCID: PMC390337](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC390337/) \cr
#'   [DOI: 10.1093/nar/gkh340](https://doi.org/10.1093/nar/gkh340)
#'
#'   RC Edgar. MUSCLE: a multiple sequence alignment method with reduced time
#'   and space complexity _BMC Bioinformatics_, 2004, 5:113. \cr
#'   [PMID: 15318951](https://www.ncbi.nlm.nih.gov/pubmed/15318951) \cr
#'   [PMCID: PMC517706](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC517706/) \cr
#'   [DOI: 10.1186/1471-2105-5-113](https://doi.org/10.1186/1471-2105-5-113)
#'
NULL

