% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityEvaluation.R
\name{calcAtomClassHydrophilicity}
\alias{calcAtomClassHydrophilicity}
\title{Atom Class Hydration Fraction}
\usage{
calcAtomClassHydrophilicity(df.AtomHydroTEMP)
}
\arguments{
\item{df.AtomHydroTEMP}{The newly calculated (determined) atomic
hydrophilicity values}
}
\value{
This function returns:
\itemize{
\item \strong{hydratFraction.oxy.neut}: Neutral oxygen atoms; enter
\code{names.resATs.oxy.neut} to see list of residue-atomtypes
\item \strong{hydratFraction.oxy.neg}: Negative oxygen atoms; enter
\code{names.resATs.oxy.neg} to see list of residue-atomtypes
\item \strong{hydratFraction.nitro.neut}: Neutral nitrogen atoms; enter
\code{names.resATs.nitro.neut} to see list of residue-atomtypes
\item \strong{hydratFraction.nitro.pos}: Positive nitrogen atoms; enter
\code{names.resATs.nitro.pos} to see list of residue-atomtypes
\item \strong{hydratFraction.carb.sulf}: Carbon and sulfur atoms; enter
\code{names.resATs.carb.sulf} to see list of residue-atomtypes
}

These values are returned in \code{HydrophilicityValues.AtomTypeClasses} of the
results of \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}
}
\description{
Calculates the mean hydration value for atoms within a class.
}
\details{
This function is called within \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} to
calculate the hydration fraction for the five atom classes listed in the
\emph{Value} section.

\deqn{(num surface exposures)/(num atom occurrences)}

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
 \dontrun{
  calcAtomClassHydrophilicity(df.AtomHydroTEMP)
 }

}
\references{
Leslie A Kuhn, Craig A Swanson, Michael E Pique, John A Tainer,
and Elizabeth D Getzof. Atomic and Residue Hydrophilicity in the Context of
Folded Protein Structures. \emph{PROTEINS: Structure, Function, and
Genetics}, 1995, \strong{23} (\emph{4}), pp 536-547.
\href{http://doi.org/10.1002/prot.340230408}{DOI: 10.1002/prot.340230408}
\href{http://www.ncbi.nlm.nih.gov/pubmed/8749849}{PMID: 8749849}
}
\seealso{
Other "Hydrophilicity Evaluation" "Bound Water Environment": \code{\link{HydrophilicityEvaluation}},
  \code{\link{calcAtomHydrationEstimate}},
  \code{\link{getProtAtomsNearWater}},
  \code{\link{getResidueData}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Hydrophilicity Evaluation" "Bound Water Environment"}
