% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxInitWaterDataSheet}
\alias{oxInitWaterDataSheet}
\title{Initial Water Data Sheet}
\usage{
oxInitWaterDataSheet(wb.name, sheet.name = "InitialWaterData", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
\code{"InitialWaterData"}}

\item{df}{data.frame containing the concatenate initial waters with
experimental and experimentally derived values obtatined within the
\code{\link[=ConservedWaters]{ConservedWaters()}} function; \emph{e.g.}, \code{h2o.df}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the initial water data.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=ConservedWaters]{ConservedWaters()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxRCSBinfoSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"openxlsx functions"}
