% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{viz_palette}
\alias{viz_palette}
\title{Show a single palette}
\usage{
viz_palette(pal, ttl = deparse(substitute(pal)), num = length(pal))
}
\arguments{
\item{pal}{character, vector of (hexadecimal) colours representing a palette}

\item{ttl}{character, title to be displayed (the name of the palette)}

\item{num}{numeric, the number of colours to display}
}
\value{
A vector of colors from a single palette
}
\description{
Display a single palette to see whether it meets your needs.
If no \code{num} parameter is given,
all the colours in the palette will be displayed.
If \code{num} is less than the number of colours in the palette,
then only the first \code{num} colours will be displayed.
If \code{num} is greater than the number of colours in the palette,
then that many colours will be generated by linear interpolation
over the vector of colours in the chosen palette.
}
\examples{
viz_palette(vangogh_palettes$StarryNight)
viz_palette(vangogh_palettes$StarryNight, "StarryNight")
viz_palette(vangogh_palettes$StarryNight, "StarryNight first 4", num = 4)
viz_palette(vangogh_palettes$StarryNight, "StarryNight interpolated to 25", num = 25)
}
