% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_vsi_list.R
\name{vapour_vsi_list}
\alias{vapour_vsi_list}
\title{Read GDAL virtual source contents}
\usage{
vapour_vsi_list(dsource, ...)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL) with virtual prefix, see Details}

\item{...}{ignored}
}
\value{
character vector listing of items
}
\description{
Obtain the names of available items in a virtual file source.
}
\details{
The \code{dsource} must begin with a valid form of the special \code{vsiPREFIX}, for details
see \href{https://gdal.org/user/virtual_file_systems.html}{GDAL Virtual File Systems}.

Note that the listing is not recursive, and so cannot be used for automation. One would
use this function interactively to determine a  useable \code{/vsiPREFIX/dsource} data
source string.
}
\examples{
\donttest{
\dontrun{
## example from https://github.com/hypertidy/vapour/issues/55
file <- "http/radmap_v3_2015_filtered_dose/radmap_v3_2015_filtered_dose.ers.zip"
url <- "http://dapds00.nci.org.au/thredds/fileServer/rr2/national_geophysical_compilations"
u <- sprintf("/vsizip//vsicurl/\%s", file.path(url, file))
vapour_vsi_list(u)
#[1] "radmap_v3_2015_filtered_dose"     "radmap_v3_2015_filtered_dose.ers"
#[3] "radmap_v3_2015_filtered_dose.isi" "radmap_v3_2015_filtered_dose.txt"
}}
}
