% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-input.R
\name{vapour_warp_raster}
\alias{vapour_warp_raster}
\title{Raster warper (reprojection)}
\usage{
vapour_warp_raster(
  x,
  bands = 1L,
  extent = NULL,
  dimension = NULL,
  projection = "",
  set_na = TRUE,
  source_wkt = NULL,
  source_extent = 0,
  resample = "near",
  silent = TRUE,
  ...,
  source_geotransform = 0,
  geotransform = NULL,
  band_output_type = "",
  warp_options = "",
  transformation_options = ""
)
}
\arguments{
\item{x}{vector of data source names (file name or URL or database connection string)}

\item{bands}{index of band/s to read (1-based), may be new order or replicated, or NULL (all bands used)}

\item{extent}{extent of the target warped raster 'c(xmin, xmax, ymin, ymax)'}

\item{dimension}{dimensions in pixels of the warped raster (x, y)}

\item{projection}{projection of warped raster (in Well-Known-Text, or any projection string accepted by GDAL)}

\item{set_na}{NOT IMPLEMENTED logical, should 'NODATA' values be set to \code{NA}}

\item{source_wkt}{optional, override or augment the projection of the source (in Well-Known-Text, or any projection string accepted by GDAL)}

\item{source_extent}{extent of the source raster, used to override/augment incorrect source metadata}

\item{resample}{resampling method used (see details in \link{vapour_read_raster})}

\item{silent}{\code{TRUE} by default, set to \code{FALSE} to report messages}

\item{...}{unused}

\item{source_geotransform}{DEPRECATED use 'source_extent' (override the native geotransform of the source)}

\item{geotransform}{DEPRECATED use 'extent' the affine geotransform of the warped raster}

\item{band_output_type}{numeric type of band to apply (else the native type if '') can be one of 'Byte', 'Int32', or 'Float64' but see details in \code{\link[=vapour_read_raster]{vapour_read_raster()}}}

\item{warp_options}{character vector of options, as in gdalwarp -wo - see Details}

\item{transformation_options}{character vector of options, as in gdalwarp -to}
}
\value{
list of vectors (only 1 for 'band') of numeric values, in raster order
}
\description{
Read a window of data from a GDAL raster source through a warp specification.
The warp specification is provided by 'extent',
'dimension', and 'projection' properties of the transformed output.
}
\details{
Any bands may be read, including repeats.

This function is not memory safe, the source is left on disk but the output
raster is all computed in memory so please be careful with very large values
for 'dimension'. \code{1000 * 1000 * 8} for 1000 columns, 1000 rows and floating point
double type will be 8Mb.

There's control over the output type, and is auto-detected from the source (raw/Byte, integer/Int32, numeric/Float64) or
can be set with 'band_output_type'.

'projection' refers to the full Well-Known-Text specification of a coordinate reference
system. See \code{\link[=vapour_srs_wkt]{vapour_srs_wkt()}} for conversion from PROJ.4 string to WKT. Any string
accepted by GDAL may be used for 'projection' or 'source_wkt', including EPSG strings, PROJ4 strings, and
file names. Note that this argument was named 'wkt' up until version 0.8.0.

'extent' is the four-figure xmin,xmax,ymin,ymax outer corners of corner pixels

'dimension' is the pixel dimensions of the output, x (ncol) then y (nrow).

Values for missing data are not yet handled, just returned
as-is. Note that there may be regions of "zero data" in a warped output,
separate from propagated missing "NODATA" values in the source.

Argument 'source_wkt' may be used to assign the projection of the source, 'source_extent'
to assign the extent of the source. Sometimes both are required.

If multiple sources are specified via 'x' and either 'source_wkt' or 'source_extent' are provided, these
are applied to every source even if they have valid values already. If this is not sensible please use VRT
to wrap the multiple sources first (see the gdalio package for some in-dev ideas).

Wild combinations of
'source_extent' and/or 'extent' may be used for arbitrary flip orientations, scale and offset. For
expert usage only. Old versions allowed transform input for target and source but this is now disabled (maybe we'll write
a new wrapper for that).
}
\section{Options}{


The 'warp_options' arguments are for 'warp options -wo',

'transformation options -to', 'creation options -co',
'open options -oo', or 'dataset open options -doo', and other arguments that use named options in gdalwarp.

To input use the appropriate argument 'warp_options' for '-wo', 'transformation_options' for '-to'.

'warp_options = c("SAMPLE_GRID=YES", "SAMPLE_STEPS=30") '

Do not include the '-wo' or the '-to', and make sure each is a separate character element. These are added in turn
with '-wo' or '-to' prepended to the string list in the implementation.

There are no creation options '-co' available, because the MEM driver is used. This might changed, see for example 'vapour_write_raster_block'.
We might add '-oo', '-doo' in future.

See \href{https://gdal.org/api/gdalwarp_cpp.html#_CPPv4N15GDALWarpOptions16papszWarpOptionsE}{GDALWarpOptions} for '-wo'.

See \href{https://gdal.org/api/gdal_alg.html#_CPPv432GDALCreateGenImgProjTransformer212GDALDatasetH12GDALDatasetHPPc}{GDAL transformation options} for '-to'.

Note we already apply the following gdalwarp arguments based on input R arguments to this function.
\itemize{
\item \strong{-of}      MEM is hardcoded, but may be extended in future
\item \strong{-t_srs}   set via 'projection'
\item \strong{-s_srs}   set via 'source_wkt'
\item \strong{-te}      set via 'extent'
\item \strong{-ts}      set via 'dimension'
\item \strong{-r}       set via 'resample'
}

note that 'source_extent' does nothing atm, there's no -se (you have to use VRT and we'll do that via new /vsivrt/ ...)
bundle any required options into 'options'.
}

\examples{
b <- 4e5
f <- system.file("extdata", "sst.tif", package = "vapour")
prj <- "+proj=aeqd +lon_0=147 +lat_0=-42"
vals <- vapour_warp_raster(f, extent = c(-b, b, -b, b),
                             dimension = c(186, 298),
                             bands = 1, 
                             projection = vapour_srs_wkt(prj), 
                             warp_options = c("SAMPLE_GRID=YES"))
                             
                             
image(list(x = seq(-b, b, length.out = 187), y = seq(-b, b, length.out = 298),
    z = matrix(unlist(vals, use.names = FALSE), 186)[,298:1]), asp = 1)
}
\seealso{
vapour_read_raster vapour_read_raster_raw vapour_read_raster_int vapour_read_raster_dbl vapour_read_raster_chr vapour_read_raster_hex
}
