% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vardcros.R
\name{vardcros}
\alias{vardcros}
\title{Variance estimation for cross-sectional, longitudinal measures for single and multistage stage cluster sampling designs}
\usage{
vardcros(
  Y,
  H,
  PSU,
  w_final,
  ID_level1,
  ID_level2,
  Dom = NULL,
  Z = NULL,
  gender = NULL,
  country = NULL,
  period,
  dataset = NULL,
  X = NULL,
  countryX = NULL,
  periodX = NULL,
  X_ID_level1 = NULL,
  ind_gr = NULL,
  g = NULL,
  q = NULL,
  datasetX = NULL,
  linratio = FALSE,
  percentratio = 1,
  use.estVar = FALSE,
  ID_level1_max = TRUE,
  outp_res = FALSE,
  withperiod = TRUE,
  netchanges = TRUE,
  confidence = 0.95,
  checking = TRUE
)
}
\arguments{
\item{Y}{Variables of interest. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{H}{The unit stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{PSU}{Primary sampling unit variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{w_final}{Weight variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ID_level1}{Variable for level1 ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ID_level2}{Optional variable for unit ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{Dom}{Optional variables used to define population domains. If supplied, variables are calculated for each domain. An object convertible to \code{data.table} or variable names as character vector, column numbers.}

\item{Z}{Optional variables of denominator for ratio estimation. If supplied, the ratio estimation is computed. Object convertible to \code{data.table} or variable names as character, column numbers. This variable is \code{NULL} by default.}

\item{gender}{Numerical variable for gender, where 1 is for males, but 2 is for females. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{country}{Variable for the survey countries. The values for each country are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{period}{Variable for the survey periods. The values for each period are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{dataset}{Optional survey data object convertible to \code{data.table}.}

\item{X}{Optional matrix of the auxiliary variables for the calibration estimator. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{countryX}{Optional variable for the survey countries. The values for each country are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{periodX}{Optional variable of the survey periods and countries. If supplied, residual estimation of calibration is done independently for each time period. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{X_ID_level1}{Variable for level1 ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ind_gr}{Optional variable by which divided independently X matrix of the auxiliary variables for the calibration. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{g}{Optional variable of the g weights. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{q}{Variable of the positive values accounting for heteroscedasticity. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{datasetX}{Optional survey data object in household level convertible to \code{data.table}.}

\item{linratio}{Logical value. If value is \code{TRUE}, then the linearized variables for the ratio estimator is used for variance estimation. If value is \code{FALSE}, then the gradients is used for variance estimation.}

\item{percentratio}{Positive numeric value. All linearized variables are multiplied with \code{percentratio} value, by default - 1.}

\item{use.estVar}{Logical value. If value is \code{TRUE}, then \code{R} function \code{estVar} is used for the  estimation of covariance matrix of the residuals. If value is \code{FALSE}, then \code{R} function \code{estVar} is not used for the estimation of covariance matrix of the residuals.}

\item{ID_level1_max}{Logical value. If value is \code{TRUE}, then the size of sample for variance under simple random sampling is taken as maximum value of size in ID_level1 . If value is \code{FALSE}, then the size of sample for variance under simple random sampling is taken as count of ID_level2 in ID_level1.}

\item{outp_res}{Logical value. If \code{TRUE} estimated residuals of calibration will be printed out.}

\item{withperiod}{Logical value. If \code{TRUE} is value, the results is with period, if \code{FALSE}, without period.}

\item{netchanges}{Logical value. If value is TRUE, then produce two objects: the first object is aggregation of weighted data by period (if available), country, strata and PSU, the second object is an estimation for Y, the variance, gradient for numerator and denominator by country and period (if available). If value is FALSE, then both objects containing \code{NULL}.}

\item{confidence}{Optional positive value for confidence interval. This variable by default is 0.95.}

\item{checking}{Optional variable if this variable is TRUE, then function checks data preparation errors, otherwise not checked. This variable by default is TRUE.}
}
\value{
A list with four objects are returned by the function:
\itemize{
   \item \code{res_out} - a \code{data.table} containing the estimated residuals of calibration with ID_level1 and PSU.
   \item \code{data_net_changes} - a \code{data.table} containing aggregation of weighted data by period (if available) and countries (if available), country, strata, PSU.
   \item \code{var_grad} - a \code{data.table} containing estimation for Y, the variance, gradient for numerator and denominator by period, country (if available) and population domains (if available).
   \item results A \code{data.table} containing: \cr
     \code{period} -  survey periods, \cr
     \code{country} - survey countries (if available), \cr
     \code{Dom} - optional variable of the population domains, \cr
     \code{namesY} - names of variables of interest, \cr
     \code{namesZ} - optional variable for names of denominator for ratio estimation, \cr
     \code{sample_size} - the sample size (in numbers of individuals), \cr
     \code{pop_size} - the population size (in numbers of individuals), \cr
     \code{total} - the estimated totals, \cr
     \code{variance} - the estimated variance of cross-sectional or longitudinal measures, \cr
     \code{sd_w} - the estimated weighted variance of simple random sample, \cr
     \code{sd_nw} - the estimated variance estimation of simple random sample, \cr
     \code{pop} - the population size (in numbers of households), \cr
     \code{sampl_siz} - the sample size (in numbers of households), \cr
     \code{stderr_w} - the estimated weighted standard error of simple random sample, \cr
     \code{stderr_nw} - the estimated standard error of simple random sample, \cr
     \code{se} - the estimated standard error of cross-sectional or longitudinal, \cr
     \code{rse} - the estimated relative standard error (coefficient of variation), \cr
     \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
     \code{absolute_margin_of_error} - the estimated absolute margin of error, \cr
     \code{relative_margin_of_error} - the estimated relative margin of error, \cr
     \code{CI_lower} - the estimated confidence interval lower bound, \cr
     \code{CI_upper} - the estimated confidence interval upper bound, \cr
     \code{confidence_level} - the positive value for confidence interval.
 }
}
\description{
Computes the variance estimation for cross-sectional and longitudinal measures for any stage cluster sampling designs.
}
\examples{
library("data.table")
library("laeken")

# Example 1
data(eusilc)
set.seed(1)
dataset1 <- data.table(eusilc)
dataset1[, year := 2010]
dataset1[, country := "AT"]
dataset1[age < 0, age := 0]
PSU <- dataset1[, .N, keyby = "db030"][, N := NULL]
PSU[, PSU := trunc(runif(nrow(PSU), 0, 100))]
dataset1 <- merge(dataset1, PSU, by = "db030", all = TRUE)
PSU <- eusilc <- 0
  
dataset1[, strata := "XXXX"]
dataset1[, t_pov := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_dep := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_lwi := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, exp := 1]
dataset1[, exp2 := 1 * (age < 60)]
  
# At-risk-of-poverty (AROP)
dataset1[, pov := ifelse (t_pov == 1, 1, 0)]
  
# Severe material deprivation (DEP)
dataset1[, dep := ifelse (t_dep == 1, 1, 0)]
  
# Low work intensity (LWI)
dataset1[, lwi := ifelse (t_lwi == 1 & exp2 == 1, 1, 0)]
  
# At-risk-of-poverty or social exclusion (AROPE)
dataset1[, arope := ifelse (pov == 1 | dep == 1 | lwi == 1, 1, 0)]

result11 <- vardcros(Y="arope", H = "strata",
                     PSU = "PSU", w_final = "rb050",
                     ID_level1 = "db030", ID_level2 = "rb030",
                     Dom = "rb090", Z = NULL, country = "country",
                     period = "year", dataset = dataset1,
                     linratio = FALSE, withperiod = TRUE,
                     netchanges = TRUE, confidence = .95)
   
\dontrun{
# Example 2
data(eusilc)
set.seed(1)
dataset1 <- data.table(rbind(eusilc, eusilc),
                       year = c(rep(2010, nrow(eusilc)),
                                rep(2011, nrow(eusilc))))
dataset1[, country := "AT"]
dataset1[age < 0, age := 0]
PSU <- dataset1[, .N, keyby = "db030"][, N := NULL]
PSU[, PSU := trunc(runif(nrow(PSU), 0, 100))]
dataset1 <- merge(dataset1, PSU, by = "db030", all = TRUE)
PSU <- eusilc <- 0
dataset1[, strata := "XXXX"]
dataset1[, strata := as.character(strata)]
dataset1[, t_pov := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_dep := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_lwi := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, exp := 1]
dataset1[, exp2 := 1 * (age < 60)]
    
# At-risk-of-poverty (AROP)
dataset1[, pov := ifelse(t_pov == 1, 1, 0)]
    
# Severe material deprivation (DEP)
dataset1[, dep := ifelse(t_dep == 1, 1, 0)]
    
# Low work intensity (LWI)
dataset1[, lwi := ifelse(t_lwi == 1 & exp2 == 1, 1, 0)]
    
# At-risk-of-poverty or social exclusion (AROPE)
dataset1[, arope := ifelse(pov == 1 | dep == 1 | lwi == 1, 1, 0)]
    
result11 <- vardcros(Y = c("pov", "dep", "arope"),
                     H = "strata", PSU = "PSU", w_final = "rb050",
                     ID_level1 = "db030", ID_level2 = "rb030",
                     Dom = "rb090", Z = NULL, country = "country",
                     period = "year", dataset = dataset1,
                     linratio = FALSE, withperiod = TRUE,
                     netchanges = TRUE, confidence = .95)
    
dataset2 <- dataset1[exp2 == 1]
result12 <- vardcros(Y = c("lwi"), H = "strata",
                     PSU = "PSU", w_final = "rb050",
                     ID_level1 = "db030", ID_level2 = "rb030",
                     Dom = "rb090", Z = NULL,
                     country = "country", period = "year",
                     dataset = dataset2, linratio = FALSE, 
                     withperiod = TRUE, netchanges = TRUE,
                     confidence = .95)
    
### Example 3
data(eusilc)
set.seed(1)
year <- 2011
dataset1 <- data.table(rbind(eusilc, eusilc, eusilc, eusilc),
                       rb010 = c(rep(2008, nrow(eusilc)),
                                 rep(2009, nrow(eusilc)),
                                 rep(2010, nrow(eusilc)),
                                 rep(2011, nrow(eusilc))))
dataset1[, rb020 := "AT"]
        
dataset1[, u := 1]
dataset1[age < 0, age := 0]
dataset1[, strata := "XXXX"]
PSU <- dataset1[, .N, keyby = "db030"][, N:=NULL]
PSU[, PSU := trunc(runif(nrow(PSU), 0, 100))]
dataset <- merge(dataset, PSU, by = "db030", all = TRUE)
thres <- data.table(rb020 = as.character(rep("AT", 4)),
                   thres = c(11406, 11931, 12371, 12791),
                   rb010 = 2008 : 2011)
dataset1 <- merge(dataset1, thres, all.x = TRUE, by = c("rb010", "rb020"))
dataset1[is.na(u), u := 0]
dataset1 <- dataset1[u == 1]
    
#############
# T3        #
#############
    
T3 <- dataset1[rb010 == year - 3]
T3[, strata1 := strata]
T3[, PSU1 := PSU]
T3[, w1 := rb050]
T3[, inc1 := eqIncome]
T3[, rb110_1 := db030]
T3[, pov1 := inc1 <= thres1]
T3 <- T3[, c("rb020", "rb030", "strata", "PSU", "inc1", "pov1"), with = FALSE]
    
#############
# T2        #
#############
T2 <- dataset1[rb010 == year - 2]
T2[, strata2 := strata]
T2[, PSU2 := PSU]
T2[, w2 := rb050]
T2[, inc2 := eqIncome]
T2[, rb110_2 := db030]
setnames(T2, "thres", "thres2")
T2[, pov2 := inc2 <= thres2]
T2 <- T2[, c("rb020", "rb030", "strata2", "PSU2", "inc2", "pov2"), with = FALSE]
    
#############
# T1        #
#############
T1 <- dataset1[rb010 == year - 1]
T1[, strata3 := strata]
T1[, PSU3 := PSU]
T1[, w3 := rb050]
T1[, inc3 := eqIncome]
T1[, rb110_3 := db030]
setnames(T1, "thres", "thres3")
T1[, pov3 := inc3 <= thres3]
T1 <- T1[, c("rb020", "rb030", "strata3", "PSU3", "inc3", "pov3"), with = FALSE]
    
#############
# T0        #
#############
T0 <- dataset1[rb010 == year]
T0[, PSU4 := PSU]
T0[, strata4 := strata]
T0[, w4 := rb050]
T0[, inc4 := eqIncome]
T0[, rb110_4 := db030]
setnames(T0, "thres", "thres4")
T0[, pov4 := inc4 <= thres4]
T0 <- T0[, c("rb020", "rb030", "strata4", "PSU4", "w4", "inc4", "pov4"), with = FALSE]
apv <- merge(T3, T2, all = TRUE, by = c("rb020", "rb030"))
apv <- merge(apv, T1, all = TRUE, by = c("rb020", "rb030"))
apv <- merge(apv, T0, all = TRUE, by = c("rb020", "rb030"))
apv <- apv[(!is.na(inc1)) & (!is.na(inc2)) & (!is.na(inc3)) & (!is.na(inc4))]
apv[, ppr := ifelse(((pov4 == 1) & ((pov1 == 1 & pov2 == 1 & pov3 == 1) 
                                  | (pov1 == 1 & pov2 == 1 & pov3 == 0)
                                  | (pov1 == 1 & pov2 == 0 & pov3 == 1)
                                  | (pov1 == 0 & pov2 ==1 & pov3 == 1))), 1, 0)]
result20 <- vardcros(Y = "ppr", H = "strata", PSU = "PSU",
                     w_final = "w4", ID_level1="rb030",
                     ID_level2 = "rb030", Dom = NULL,
                     Z = NULL, country = "rb020",
                     period = NULL, dataset = apv,
                     linratio = FALSE, 
                     withperiod = FALSE,
                     netchanges = FALSE,
                     confidence = .95)
result20}


}
\references{
Guillaume Osier,  Yves Berger,  Tim Goedeme, (2013), Standard error estimation for the EU-SILC indicators of poverty and social exclusion,  Eurostat Methodologies and Working papers, URL \url{http://ec.europa.eu/eurostat/documents/3888793/5855973/KS-RA-13-024-EN.PDF}. \cr
Yves G. Berger, Tim Goedeme, Guillame Osier (2013). Handbook on standard error estimation and other related sampling issues in EU-SILC, URL \url{https://ec.europa.eu/eurostat/cros/content/handbook-standard-error-estimation-and-other-related-sampling-issues-ver-29072013_en} \cr
Eurostat Methodologies and Working papers, Handbook on precision requirements and variance estimation for ESS household surveys, 2013, URL \url{http://ec.europa.eu/eurostat/documents/3859598/5927001/KS-RA-13-029-EN.PDF}. \cr
}
\seealso{
\code{\link{domain}},
         \code{\link{lin.ratio}}
}
\keyword{vardcros}
