% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.variant.calling.R
\name{run.variant.calling}
\alias{run.variant.calling}
\title{run.variant.calling}
\usage{
run.variant.calling(bam.specification, output.directory,
  variant.callers = c("vardict", "mutect", "varscan", "lofreq", "muse"),
  paired = TRUE, proton = FALSE, sample.directories = TRUE,
  job.name.prefix = NULL, quiet = FALSE, verify.options = !quiet)
}
\arguments{
\item{bam.specification}{Data frame containing details of BAM files to be processed, typically from \code{prepare.bam.specification}.}

\item{output.directory}{Path to directory where output should be saved}

\item{variant.callers}{Character vector of variant callers to be used}

\item{paired}{Logical indicating whether to do variant calling with a matched normal}

\item{proton}{Logical indicating whether data was generated by proton sequencing (ignored if running MuTect)}

\item{sample.directories}{Logical indicating whether output for each sample should be put in its own directory (within output.directory)}

\item{job.name.prefix}{Prefix for job names on the cluster}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit the job}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\value{
None
}
\description{
Run variant calling for all samples
}
\details{
Run VarDict on each sample, and annotate the results with ANNOVAR. 
 Files are output to a vardict/ subdirectory within each sample directory.
}
\examples{
run.variant.calling(
  data.frame(sample.id = c('Z', 'Y'), tumour.bam = c('Z.bam', 'Y.bam')),
  output.directory = '.',
  variant.caller = c('lofreq', 'mutect'),
  quiet = TRUE,
  paired = FALSE
)

}
