\name{Phi}

\alias{Phi}

\alias{Phi.varest}

\alias{Phi.svarest}

\encoding{latin1}

\title{Coefficient matrices of the MA represention}
\description{
  Returns the estimated coefficient matrices of the moving average
  representation of a stable VAR(p) or of an SVAR as an array.
}

\usage{
\method{Phi}{varest}(x, nstep=10, ...)
\method{Phi}{svarest}(x, nstep=10, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varest}}, generated by
    \command{VAR()}, or an object of class \sQuote{\code{svarest}},
    generated by \command{SVAR()}.}  
  \item{nstep}{An integer specifying the number of moving error
    coefficient matrices to be calculated.}
  \item{...}{Currently not used.}
}

\details{
  If the process \eqn{\bold{y}_t} is stationary (\emph{i.e.} \eqn{I(0)},
  it has a Wold moving average representation in the form of:
  \deqn{
    \bold{y}_t = \Phi_0 \bold{u}_t + \Phi_1 \bold{u}_{t-1} + \Phi
    \bold{u}_{t-2} + \ldots ,
  }
  whith \eqn{\Phi_0 = I_k} and the matrices \eqn{\Phi_s} can be computed
  recursively according to:

  \deqn{
    \Phi_s = \sum_{j=1}^s \Phi_{s-j} A_j \quad s = 1, 2, \ldots ,
  }

  whereby \eqn{A_j} are set to zero for \eqn{j > p}. The matrix elements
  represent the impulse responses of the components of \eqn{\bold{y}_t}
  with respect to the shocks \eqn{\bold{u}_t}. More precisely, the
  \eqn{(i, j)}th element of the matrix \eqn{\Phi_s} mirrors the expected
  response of \eqn{y_{i, t+s}} to a unit change of the variable
  \eqn{y_{jt}}.
  \cr
  In case of a SVAR, the impulse response matrices are given by:
  \deqn{
    \Theta_i = \Phi_i A^{-1} B \quad .
  }  
}

\value{
  An array with dimension \eqn{(K \times K \times nstep + 1)} holding the
  estimated coefficients of the moving average representation.
}

\note{
  The first returned array element is the starting value, \emph{i.e.}, \eqn{\Phi_0}.
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{Psi}}, \code{\link{VAR}}, \code{\link{SVAR}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
Phi(var.2c, nstep=4)
}

\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive}
\concept{Moving Average Representation}
\concept{Impulse Response Function}
\concept{Impulse Responses}
