% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_manager.R, R/vault_server_instance.R
\name{vault_test_server}
\alias{vault_test_server}
\alias{vault_server_instance}
\alias{vault_test_server_install}
\title{Control a test vault server}
\usage{
vault_test_server(https = FALSE, init = TRUE, if_disabled = testthat::skip)

vault_test_server_install(
  path = NULL,
  quiet = FALSE,
  version = "1.0.0",
  platform = vault_platform()
)
}
\arguments{
\item{https}{Logical scalar, indicating if a https-using server
should be created, rather than the default vault dev-mode
server.  This is still \emph{entirely} insecure, and uses self
signed certificates that are bundled with the package.}

\item{init}{Logical scalar, indicating if the https-using server
should be initialised.}

\item{if_disabled}{Callback function to run if the vault server is
not enabled.  The default, designed to be used within tests, is
\code{testthat::skip}.  Alternatively, inspect the
\verb{$enabled} property of the returned object.}

\item{path}{Path in which to install vault test server. Leave as
\code{NULL} to use the \code{VAULTR_TEST_SERVER_BIN_PATH} environment
variable.}

\item{quiet}{Suppress progress bars on install}

\item{version}{Version of vault to install}

\item{platform}{For testing, overwrite the platform vault is being
installed on, with either "windows", "darwin" or "linux".}
}
\description{
Control a server for use with testing.  This is designed to be
used only by other packages that wish to run tests against a vault
server.  You will need to set \code{VAULTR_TEST_SERVER_BIN_PATH}
to point at the directory containing the vault binary.
}
\details{
Once created with \code{vault_test_server}, a server will stay
alive for as long as the R process is alive \emph{or} until the
\code{vault_server_instance} object goes out of scope and is
garbage collected.  Calling \verb{$kill()} will explicitly stop
the server, but this is not strictly needed.  See below for
methods to control the server instance.

The function \code{vault_test_server_install} will install a test
server, but \emph{only} if the user sets the following environmental
variables:
\itemize{
\item \code{VAULTR_TEST_SERVER_INSTALL} to \code{"true"} to opt in to the
download.
\item \code{VAULTR_TEST_SERVER_BIN_PATH} to the directory where the binary
should be downloaded to.
\item \code{NOT_CRAN} to \code{"true"} to indicate this is not running on CRAN
as it requires installation of a binary from a website.
}

This will download a ~100MB binary from https://vaultproject.io
so use with care.  It is intended \emph{only} for use in automated
testing environments.
}
\section{Warning}{


Starting a server in test mode must \emph{not} be used for production
under any circumstances.  As the name suggests,
\code{vault_test_server} is a server suitable for \emph{tests} only and
lacks any of the features required to make vault secure.  Please
see https://www.vaultproject.io/docs/concepts/dev-server.html
for more information



The \code{vault_test_server_install} function will download a
binary from HashiCorp in order to use a vault server.  Use this
function with care.  The download will happen from
https://releases.hashicorp.com/vault (over https).  This
function is primarily designed to be used from continuous
integration services only and for local use you are strongly
recommended to curate your own installations.
}

\examples{

# Try and start a server; if one is not enabled (see details
# above) then this will return NULL
server <- vault_test_server(if_disabled = message)

if (!is.null(server)) {
  # We now have a server running on an arbitrary high port - note
  # that we are running over http and in dev mode: this is not at
  # all suitable for production use, just for tests
  server$addr

  # Create clients using the client method - by default these are
  # automatically authenticated against the server
  client <- server$client()
  client$write("/secret/password", list(value = "s3cret!"))
  client$read("/secret/password")

  # The server stops automatically when the server object is
  # garbage collected, or it can be turned off with the
  # 'kill' method:
  server$kill()
  tryCatch(client$status(), error = function(e) message(e$message))
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_server_instance}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{port}}{The vault port (read-only).}

\item{\code{addr}}{The vault address; this is suitable for using with
\link{vault_client} (read-only).}

\item{\code{token}}{The vault root token, from when the testing vault
server was created.  If the vault is rekeyed this will no
longer be accurate (read-only).}

\item{\code{keys}}{Key shares from when the vault was initialised
(read-only).}

\item{\code{cacert}}{Path to the https certificate, if running in
https mode (read-only).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{vault_server_instance$new()}}
\item \href{#method-version}{\code{vault_server_instance$version()}}
\item \href{#method-client}{\code{vault_server_instance$client()}}
\item \href{#method-env}{\code{vault_server_instance$env()}}
\item \href{#method-export}{\code{vault_server_instance$export()}}
\item \href{#method-clear_cached_token}{\code{vault_server_instance$clear_cached_token()}}
\item \href{#method-kill}{\code{vault_server_instance$kill()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format">}\href{../../vaultr/html/vault_client_object.html#method-format}{\code{vaultr::vault_client_object$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help">}\href{../../vaultr/html/vault_client_object.html#method-help}{\code{vaultr::vault_client_object$help()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_server_instance} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$new(bin, port, https, init)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bin}}{Path to the vault binary}

\item{\code{port}}{Port to use}

\item{\code{https}}{Logical, indicating if we should use TLS/https}

\item{\code{init}}{Logical, indicating if we should initialise}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-version"></a>}}
\if{latex}{\out{\hypertarget{method-version}{}}}
\subsection{Method \code{version()}}{
Return the server version, as a \link{numeric_version}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-client"></a>}}
\if{latex}{\out{\hypertarget{method-client}{}}}
\subsection{Method \code{client()}}{
Create a new client that can use this server.  The
client will be a \link{vault_client} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$client(login = TRUE, quiet = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{login}}{Logical, indicating if the client should login to
the server (default is \code{TRUE}).}

\item{\code{quiet}}{Logical, indicating if informational messages
should be suppressed.  Default is \code{TRUE}, in contrast with
most other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-env"></a>}}
\if{latex}{\out{\hypertarget{method-env}{}}}
\subsection{Method \code{env()}}{
Return a named character vector of environment
variables that can be used to communicate with this vault
server (\code{VAULT_ADDR}, \code{VAULT_TOKEN}, etc).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$env()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-export"></a>}}
\if{latex}{\out{\hypertarget{method-export}{}}}
\subsection{Method \code{export()}}{
Export the variables returned by the \verb{$env()}
method to the environment.  This makes them available to
child processes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$export()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_cached_token"></a>}}
\if{latex}{\out{\hypertarget{method-clear_cached_token}{}}}
\subsection{Method \code{clear_cached_token()}}{
Clear any session-cached token for this server.
This is intended for testing new authentication backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$clear_cached_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-kill"></a>}}
\if{latex}{\out{\hypertarget{method-kill}{}}}
\subsection{Method \code{kill()}}{
Kill the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$kill()}\if{html}{\out{</div>}}
}

}
}
