% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryMETA.R
\name{queryMETA}
\alias{queryMETA}
\title{Query the META section of VCF data}
\usage{
queryMETA(x, element = NULL, nice = TRUE)
}
\arguments{
\item{x}{an object of class vcfR or chromR.}

\item{element}{an acronym to search for in the META portion of the VCF data.}

\item{nice}{logical indicating whether to format the data in a 'nice' manner.}
}
\description{
Query the META section of VCF data for information about acronyms.
}
\details{
The META portion of VCF data defines acronyms that are used elsewhere in the data.
In order to better understand these acronyms they should be referenced.
This function facilitates looking up of acronyms to present their relevant information.
When 'element' is 'NULL' (the default), all acronyms from the META region are returned.
When 'element' is specified an attempt is made to return information about the provided element.
The function \code{grep} is used to perform this query.
If 'nice' is set to FALSE then the data is presented as it was in the file.
If 'nice' is set to TRUE the data is processed to make it appear more 'nice'.
}
\examples{
data(vcfR_test)
queryMETA(vcfR_test)
queryMETA(vcfR_test, element = "DP")


}
\seealso{
\code{\link[base]{grep}}, \code{\link[base]{regex}}.
}
