% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.stdmean.ps}
\alias{se.stdmean.ps}
\title{Computes the standard error for a paired-samples standardized mean difference}
\usage{
se.stdmean.ps(m1, m2, sd1, sd2, cor, n, stdzr)
}
\arguments{
\item{m1}{sample mean for measurement 1}

\item{m2}{sample mean for measurement 2}

\item{sd1}{sample standard deviation for measurement 1}

\item{sd2}{sample standard deviation for measurement 2}

\item{cor}{sample correlation for measurements 1 and 2}

\item{n}{sample size}

\item{stdzr}{\itemize{
\item set to 0 for square root average variance standardizer
\item set to 1 for group 1 SD standardizer
\item set to 2 for group 2 SD standardizer
\item set to 3 for square root weighted variance standardizer
}}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimate of standardized mean difference
\item SE - standard error
}
}
\description{
The effect size estimate and standard error output from this function can be used
as input in the \link[vcmeta]{meta.ave.gen}, \link[vcmeta]{meta.lc.gen}, and
\link[vcmeta]{meta.lm.gen} functions in applications where compatible standardized
mean differences from a combination of 2-group and paired-samples experiments are
used in the meta-analysis.
}
\examples{
se.stdmean.ps(23.9, 25.1, 1.76, 2.01, .78, 25, 0)

# Should return: 
#                                  Estimate        SE
# Standardizedd mean difference: -0.6352097 0.1602852


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
