% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightswitch.R
\name{lightswitch}
\alias{lightswitch}
\alias{turn_on}
\alias{turn_off}
\alias{turned_off}
\alias{turned_on}
\alias{skip_if_vcr_off}
\title{Turn vcr on and off}
\usage{
turn_on()

turn_off(ignore_cassettes = FALSE)

turned_off(code, ignore_cassettes = FALSE)

turned_on()

skip_if_vcr_off()
}
\arguments{
\item{ignore_cassettes}{(logical) Controls what happens when a cassette is
inserted while vcr is turned off. If \code{TRUE} is passed, the cassette
insertion will be ignored; otherwise an error will be raised.
Default: \code{FALSE}}

\item{code}{Any block of code to run, presumably an HTTP request.}
}
\description{
\itemize{
\item \code{turn_on()} and \code{turn_off()} turn on and off for the whole session.
\item \code{turned_off(code)} temporarily turns off while \code{code} is running,
guaranteeing that you make a real HTTP request.
\item \code{turned_on()} reports on if vcr is turned on or not.
\item \code{skip_if_vcr_off()} skips a test if vcr is turned off. This is
occasionally useful if you're using a cassette to simulate a faked
request, or if the real request would return different values (e.g.
you're testing date parsing and the request returns the current date).
}

You can also control the default behaviour in a new session by setting the
following environment variables before R starts:
\itemize{
\item Use \code{VCR_TURN_OFF=true} to suppress all vcr usage, ignoring all
cassettes. This is useful for CI/CD workflows where you want to ensure
the test suite is run against the live API.
\item Set \code{VCR_TURNED_OFF=true} to turn off vcr, but still use cassettes.
}
}
\examples{
# By default, vcr is turned on
turned_on()

# you can turn off for the rest of the session
turn_off()
turned_on()
# turn on again
turn_on()

# or just turn it on turn off temporarily
turned_off({
  # some HTTP requests here
  turned_on()
})
}
