% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{new_partial}
\alias{new_partial}
\alias{is_partial}
\alias{vec_ptype_finalise}
\title{Partial type}
\usage{
new_partial(..., class = character())

is_partial(x)

vec_ptype_finalise(x, ...)
}
\arguments{
\item{...}{Attributes of the partial type}

\item{class}{Name of subclass.}
}
\description{
Use \code{new_partial()} when constructing a new partial type subclass;
and use \code{is_partial()} to test if an type is partial. All subclasses
need to provide a \code{vec_ptype_finalise()} method.
}
\details{
As the name suggests, a partial type \emph{partially} specifies a type, and
it must be combined with data to yield a full type. A useful example
of a partial type is \code{\link[=partial_frame]{partial_frame()}}, which makes it possible to
specify the type of just a few columns in a data frame. Use this constructor
if you're making your own partial type.
}
\keyword{internal}
