% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{vec_equal}
\alias{vec_equal}
\alias{vec_equal_na}
\title{Test if two vectors are equal}
\usage{
vec_equal(x, y, na_equal = FALSE, .ptype = NULL)

vec_equal_na(x)
}
\arguments{
\item{x}{Vectors with compatible types and lengths.}

\item{y}{Vectors with compatible types and lengths.}

\item{na_equal}{Should \code{NA} values be considered equal?}

\item{.ptype}{Override to optionally specify common type}
}
\value{
A logical vector the same size as. Will only contain \code{NA}s if \code{na_equal} is \code{FALSE}.
}
\description{
\code{vec_equal_na()} tests a special case: equality with \code{NA}. It is similar to
\link{is.na} but:
\itemize{
\item Considers the missing element of a list to be \code{NULL}.
\item Considered data frames and records to be missing if every component
is missing.
This preserves the invariant that \code{vec_equal_na(x)} is equal to
\code{vec_equal(x, vec_init(x), na_equal = TRUE)}.
}
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_cast_common]{vec_cast_common()}} with fallback
\item \code{\link[=vec_recycle_common]{vec_recycle_common()}}
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
}
}

\examples{
vec_equal(c(TRUE, FALSE, NA), FALSE)
vec_equal(c(TRUE, FALSE, NA), FALSE, na_equal = TRUE)
vec_equal_na(c(TRUE, FALSE, NA))

vec_equal(5, 1:10)
vec_equal("d", letters[1:10])

df <- data.frame(x = c(1, 1, 2, 1, NA), y = c(1, 2, 1, NA, NA))
vec_equal(df, data.frame(x = 1, y = 2))
vec_equal_na(df)
}
