% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-data-frame.R
\name{df_list}
\alias{df_list}
\title{Collect columns for data frame construction}
\usage{
df_list(
  ...,
  .size = NULL,
  .unpack = TRUE,
  .name_repair = c("check_unique", "unique", "universal", "minimal", "unique_quiet",
    "universal_quiet"),
  .error_call = current_env()
)
}
\arguments{
\item{...}{Vectors of equal-length. When inputs are named, those names
are used for names of the resulting list.}

\item{.size}{The common size of vectors supplied in \code{...}. If \code{NULL}, this
will be computed as the common size of the inputs.}

\item{.unpack}{Should unnamed data frame inputs be unpacked? Defaults to
\code{TRUE}.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[=vec_as_names]{vec_as_names()}}
for the meaning of these options.}

\item{.error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\description{
\code{df_list()} constructs the data structure underlying a data
frame, a named list of equal-length vectors. It is often used in
combination with \code{\link[=new_data_frame]{new_data_frame()}} to safely and consistently create
a helper function for data frame subclasses.
}
\section{Properties}{

\itemize{
\item Inputs are \link[=theory-faq-recycling]{recycled} to a common size with
\code{\link[=vec_recycle_common]{vec_recycle_common()}}.
\item With the exception of data frames, inputs are not modified in any way.
Character vectors are never converted to factors, and lists are stored
as-is for easy creation of list-columns.
\item Unnamed data frame inputs are automatically unpacked. Named data frame
inputs are stored unmodified as data frame columns.
\item \code{NULL} inputs are completely ignored.
\item The dots are dynamic, allowing for splicing of lists with \verb{!!!} and
unquoting.
}
}

\examples{
# `new_data_frame()` can be used to create custom data frame constructors
new_fancy_df <- function(x = list(), n = NULL, ..., class = NULL) {
  new_data_frame(x, n = n, ..., class = c(class, "fancy_df"))
}

# Combine this constructor with `df_list()` to create a safe,
# consistent helper function for your data frame subclass
fancy_df <- function(...) {
  data <- df_list(...)
  new_fancy_df(data)
}

df <- fancy_df(x = 1)
class(df)
}
\seealso{
\code{\link[=new_data_frame]{new_data_frame()}} for constructing data frame subclasses from a validated
input. \code{\link[=data_frame]{data_frame()}} for a fast data frame creation helper.
}
