% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_info.R
\name{ts_info}
\alias{ts_info}
\title{Create an object with information about a time series}
\usage{
ts_info(historical, ..., future = NULL, name = NULL)
}
\arguments{
\item{historical}{a time series of class \code{ts} with the historical values
of the series.}

\item{...}{forecasts for the future values of the time series. A forecast
must have been built with the \code{\link[=prediction_info]{prediction_info()}} function. See the
examples section.}

\item{future}{NULL (default) or a time series of class \code{ts} or a vector.
The future values of the time series (possibly to be forecast).}

\item{name}{NULL (default) or a character string with information about the
time series. Typically, its name.}
}
\value{
An object of class \code{ts_info}. It is a list containing all the
information supplied to the function.
}
\description{
The information about the time series is compounded of the time series and,
optionally, its future values and forecasts for those future values (and
prediction intervals for those forecasts).
}
\examples{
# only information about a time series
info <- ts_info(USAccDeaths)

# Information about a time series and its future values
info2 <- ts_info(ts(rnorm(50)), future = rnorm(10))

# Information about a time series, its future values and a forecast
if (require("forecast")) {
  t <- ts(rnorm(50))
  f <- rnorm(10)
  mf <- meanf(t, level = 95)
  info3 <- ts_info(t, future = f,
                   prediction_info("mean", mf$mean,
                                   pi_info(95, mf$lower, mf$upper)
                   )
  )
}
}
\seealso{
\code{\link[=prediction_info]{prediction_info()}} for how to create forecasts.
}
