% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv.write.R
\name{tv.write}
\alias{tv.write}
\title{Write species-plot observations and site information to Turboveg database.}
\usage{
tv.write(x, site, name, tvadmin, remarks, dict = "", cover = c("code", "perc"),
drop = FALSE, obl = TRUE, overwrite = FALSE, ...)
}
\arguments{
\item{x}{(data.frame) Either observations data.frame with RELEVE_NR, TaxonUsageID and COVER_CODE (see \link{tv.obs}) columns or vegetation matrix of class "veg".}

\item{site}{(character) Header data for plots.}

\item{name}{(character) Name of the new database.}

\item{tvadmin}{(data.frame) Dataframe with plot UUID's and Turboveg columns from TvAdmin.dbf. A new file with new unique identifiers will be created if omitted.}

\item{remarks}{(data.frame) Remarks in Turboveg format if the comments for individual plots exceed 254 characters. See remarks.dbf in Turboveg databases. An empty file will be created if omitted.}

\item{dict}{(character) Turboveg dictionary name}

\item{cover}{(logical) Use of covercodes or (mean) cover percentages, see Details.}

\item{drop}{(logical) Drop columns which are empty or contain only NA values.}

\item{obl}{(logical) Add obligatory fields defined in the TV dictionary but not present in the site data table.}

\item{overwrite}{(logical) Should an existing database be overwritten.}

\item{\dots}{additional arguments}
}
\value{
Five files will be created in "tv_home/Data/databasename" directory. \emph{tvabund.dbf} with occurrence information n long format, \emph{tvhabita.dbf} with plot information, remarks.dbf with comments longer then 255 characters, \emph{TvAdmin.dbf} with plot UUID's and tvwin.dbf with information about taxonomic reference list, and dictionary used.
}
\description{
Write species-plot observations and site information to Turboveg database.
}
\details{
By default Covercode is written to Turboveg. This is only meaningful, if correct CoverScales are given in the site dataframe. Unique plot ID's are stored in \emph{TvAdmin.dbf}. If you want to preserve already given UUID's you have to prepare an appropriate data.frame. Look for existing \emph{TvAdmin.dbf} files for necessary columns.
}
\seealso{
tv.veg
}
\author{
Florian Jansen @email florian.jansen@uni-rostock.de
}
\keyword{Turboveg}
