% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_nitro.R
\name{ef_nitro}
\alias{ef_nitro}
\title{Emissions factors of N2O and NH3}
\usage{
ef_nitro(v, t, cc, f, eu, p, S, k = 1, show.equation = TRUE)
}
\arguments{
\item{v}{Category vehicle: "PC", "LCV", "Motorcycle" or "Moped}

\item{t}{Type: "PC", "LCV", "LDV", "Motorcycles", "Trucks", "HDV", "HDV-A",
"BUS" and "Coach"}

\item{cc}{"Cold", "Hot", "<50", ">=50", ">3.5", "7.5_12", "12_28", "28_34",
">34", "ALL".}

\item{f}{Type of fuel: "G", "D" or "LPG"}

\item{eu}{Euro standard: "PRE", "I", "II", "III", "III+DPF", "IV", "V", "VI",
"VIc", "2S",  4S" and "ALL"}

\item{p}{Pollutant: "N2O", "NH3"}

\item{S}{Sulphur (ppm)}

\item{k}{Multiplication factor}

\item{show.equation}{Option to see or not the equation parameters}
}
\value{
an emission factor function which depends of the average speed V  g/km
}
\description{
This function returns emission factors as a functions of accumulated mileage.
The emission factors comes from the guidelines  EMEP/EEA air pollutant
emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
}
\examples{
\dontrun{
# Do not run
V <- 0:150
ef1 <- ef_ldv_speed(v = "PC",t = "PRE_ECE", cc = "ALL", f = "G", eu = "PRE", p = "CO")
plot(1:150, ef1(1:150))
}
}
\keyword{emission}
\keyword{factors}
\keyword{speed}
