% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_ldv_cold_list.R
\name{ef_ldv_cold_list}
\alias{ef_ldv_cold_list}
\title{List of cold start emission factors of Light Duty Vehicles}
\usage{
ef_ldv_cold_list(df, v = "LDV", ta, cc, f, eu, p)
}
\arguments{
\item{df}{Dataframe with local emission factor}

\item{v}{Category vehicle: "LDV"}

\item{ta}{ambient temperature. Montly average van be used}

\item{cc}{Size of engine in cc: <=1400", "1400_2000" and ">2000"}

\item{f}{Type of fuel: "G" or "D"}

\item{eu}{character vector of euro standards: "PRE", "I", "II", "III", "IV",
"V", "VI" or "VIc".}

\item{p}{Pollutant: "CO", "FC", "NOx", "HC" or "PM"}
}
\value{
A list of cold start emission factors  g/km
}
\description{
This function creates a list of functions of cold start emission factors
considering different euro emission standard to the elements of the list.
}
\note{
The length of the list should be equal to the name of the age categories of
a specific type of vehicle
}
\examples{
\dontrun{
# Do not run
df <- data.frame(age1 = c(1,1), age2 = c(2,2))
eu = c("I", "PRE")
l <- ef_ldv_cold(t = 17, cc = "<=1400", f = "G",
eu = "I", p = "CO")
l_cold <- ef_ldv_cold_list(df, t = 17, cc = "<=1400", f = "G",
eu = eu, p = "CO")
length(l_cold)
}
}
\keyword{cold}
\keyword{emission}
\keyword{factors}
\keyword{start}
