% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_im2col.R
\name{VeloxRaster_col2im}
\alias{VeloxRaster_col2im}
\title{col2im}
\arguments{
\item{mat}{The matrix of flattened image patches.}

\item{wrow}{Patch size in the y dimension.}

\item{wcol}{Patch size in the x dimension.}

\item{band}{The band to be assigned.}

\item{rowframe}{A non-negative integer specifying the size of the frame around
the image patches in the y dimension.}

\item{colframe}{A non-negative integer specifying the size of the frame around
the image patches in the x dimension.}

\item{rowstride}{A positive integer denoting the stride between extracted patches
in the y dimension.}

\item{colstride}{A positive integer denoting the stride between extracted patches
in the x dimension.}
}
\value{
Void.
}
\description{
Assigns values to a VeloxRaster band from a matrix of flattened image patches.
Patch frames, as specified by \code{rowframe} and \code{rowframe}, are not assigned.
This function is intended to be used with \code{mat} matrices constructed with the \code{im2col} function.
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Apply im2col
patch.mat <- vx$im2col(wrow=2, wcol=2, band=1, padval=0,
                       rowframe=1, colframe=1, rowstride=2, colstride=2)
## Apply col2im
vx$col2im(mat=patch.mat, wrow=2, wcol=2, band=1, rowframe=1, colframe=1, rowstride=2, colstride=2)
isTRUE(all.equal(mat, vx$as.matrix()))

}

