% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostgeom.R
\name{unboost}
\alias{unboost}
\alias{unboost.BoostMultiLines}
\alias{unboost.BoostMultiPoints}
\alias{unboost.BoostMultiPolygons}
\title{Cast a BoostGeometries object as a sfc object}
\usage{
unboost(x, ...)

\method{unboost}{BoostMultiPolygons}(x, ...)

\method{unboost}{BoostMultiLines}(x, ...)

\method{unboost}{BoostMultiPoints}(x, ...)
}
\arguments{
\item{x}{A BoostGeometries object.}

\item{...}{Currently not used.}
}
\value{
A sfc object.
}
\description{
\code{unboost} creates a sfc object from a BoostGeometries object. Note that all sfc objects
created by unboost are of type MULTI.
}
\examples{
## Make sfc_MULTIPOINT
sfc <- sf::st_sfc(sf::st_multipoint(cbind(0,1)))
## Cast to BoostPoints
boostPoints <- boost(sfc)
## Unboost
sfc2 <- unboost(boostPoints)
print(identical(sfc, sfc2))

}

